\name{nexus_head_ct_rule}
\alias{nexus_head_ct_rule}
\title{
NEXUS Head CT Decision Instrument
}
\description{
Calculates the NEXUS Head CT result to determine the need for head CT imaging in blunt head trauma patients. If any one of the eight criteria is present, the patient is not considered low risk, and imaging is indicated.
}
\usage{
nexus_head_ct_rule(age_ge_65, skull_fracture_evidence, scalp_hematoma,
                   neurologic_deficit, altered_alertness, abnormal_behavior,
                   coagulopathy, persistent_vomiting)
}
\arguments{
  \item{age_ge_65}{
Numeric (0 or 1). Is the patient 65 years of age or older? (1 = Yes).
}
  \item{skull_fracture_evidence}{
Numeric (0 or 1). Evidence of significant skull fracture? (1 = Yes).
}
  \item{scalp_hematoma}{
Numeric (0 or 1). Scalp hematoma present? (1 = Yes).
}
  \item{neurologic_deficit}{
Numeric (0 or 1). Neurologic deficit present? (1 = Yes).
}
  \item{altered_alertness}{
Numeric (0 or 1). Altered level of alertness? (1 = Yes).
}
  \item{abnormal_behavior}{
Numeric (0 or 1). Abnormal behavior present? (1 = Yes).
}
  \item{coagulopathy}{
Numeric (0 or 1). Coagulopathy present? (1 = Yes).
}
  \item{persistent_vomiting}{
Numeric (0 or 1). Persistent vomiting? (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding the need for Head CT ("Indicated" or "Not Indicated").}
\item{Inputs}{A summary of the criteria evaluated.}
}
\references{
Mower WR, Hoffman JR, Herbert M, et al. Developing a decision instrument to guide computed tomographic imaging of blunt head injury patients. J Trauma. 2005;59(4):954-959. doi:10.1097/01.ta.0000187813.79047.42
}
\examples{

# Example 1: Low Risk
# No criteria present
nexus_head_ct_rule(0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Indicated (Age)
# 70yo, no other findings
nexus_head_ct_rule(1, 0, 0, 0, 0, 0, 0, 0)
}
