\name{must_screening_tool}
\alias{must_screening_tool}
\title{
Malnutrition Universal Screening Tool (MUST)
}
\description{
Calculates the MUST score to identify adults who are malnourished, at risk of malnutrition (undernutrition), or obese. It also includes management guidelines which can be used to develop a care plan.
}
\usage{
must_screening_tool(bmi, weight_loss_percent, acute_disease_effect)
}
\arguments{
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2).
>20.0: 0 pts.
18.5-20.0: 1 pt.
<18.5: 2 pts.
}
  \item{weight_loss_percent}{
Numeric. Unplanned weight loss in the past 3-6 months (percent).
<5\%: 0 pts.
5-10\%: 1 pt.
>10\%: 2 pts.
}
  \item{acute_disease_effect}{
Numeric (0 or 1). Is the patient acutely ill and there has been or is likely to be no nutritional intake for >5 days? (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{MUST_Score}{The calculated total score (Range 0-6).}
\item{Risk_Category}{Classification (Low Risk: 0, Medium Risk: 1, High Risk: >=2).}
\item{Management_Guideline}{General management recommendations based on the risk category.}
}
\references{
Stratton RJ, Hackston A, Longmore D, et al. Malnutrition in hospital outpatients and inpatients: prevalence, concurrent validity and ease of use of the 'malnutrition universal screening tool' ('MUST') for adults. Br J Nutr. 2004;92(5):799-808. doi:10.1079/bjn20041258
}
\examples{

# Example 1: High Risk
# BMI 17 (+2), No weight loss (0), No acute illness (0)
# Score = 2
must_screening_tool(17, 0, 0)

# Example 2: Medium Risk
# BMI 22 (0), 7% weight loss (+1), No acute illness (0)
# Score = 1
must_screening_tool(22, 7, 0)
}
