\name{mumtaz_cirrhosis_readmission_score}
\alias{mumtaz_cirrhosis_readmission_score}
\title{
Mumtaz Score for Readmission in Cirrhosis
}
\description{
Calculates the Mumtaz Score to predict the 30-day readmission risk in patients with decompensated cirrhosis. The score uses variables from the index admission, including demographics, comorbidities (Elixhauser), etiology, complications (ascites, HE, variceal bleed), procedures (paracentesis, dialysis), and discharge disposition.
}
\usage{
mumtaz_cirrhosis_readmission_score(age, primary_payer, elixhauser_comorbidity_score,
                                   non_alcoholic_etiology, ascites_present,
                                   hepatic_encephalopathy_present,
                                   variceal_bleeding_present, hcc_present,
                                   paracentesis_performed, hemodialysis_performed,
                                   disposition)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (18-39: +7, 40-64: +4, >=65: 0).
}
  \item{primary_payer}{
String. "medicare" (+4), "medicaid" (+5), "private" (0), "self_pay" (-3), "no_charge_other" (-1).
}
  \item{elixhauser_comorbidity_score}{
Numeric. Elixhauser Comorbidity Index score. (>=3: +2, <3: 0).
}
  \item{non_alcoholic_etiology}{
Numeric (0 or 1). Is the cirrhosis etiology non-alcoholic? (1 = Yes, +2 pts).
}
  \item{ascites_present}{
Numeric (0 or 1). Presence of ascites. (1 = Yes, +5 pts).
}
  \item{hepatic_encephalopathy_present}{
Numeric (0 or 1). Presence of hepatic encephalopathy. (1 = Yes, +4 pts).
}
  \item{variceal_bleeding_present}{
Numeric (0 or 1). Presence of variceal bleeding. (1 = Yes, -7 pts).
}
  \item{hcc_present}{
Numeric (0 or 1). Presence of Hepatocellular Carcinoma. (1 = Yes, +3 pts).
}
  \item{paracentesis_performed}{
Numeric (0 or 1). Paracentesis performed during admission. (1 = Yes, +4 pts).
}
  \item{hemodialysis_performed}{
Numeric (0 or 1). Hemodialysis performed during admission. (1 = Yes, +7 pts).
}
  \item{disposition}{
String. Discharge disposition. "routine" (0), "transfer" (-1), "home_health" (+3), "ama" (+10).
}
}
\value{
A list containing:
\item{Mumtaz_Score}{The calculated risk score.}
\item{Risk_Category}{Risk classification (Low, Medium, High).}
\item{Est_30_Day_Readmission_Risk}{Estimated probability of readmission within 30 days.}
}
\references{
Mumtaz K, Issak A, Porter K, et al. Validation of Risk Score in Predicting Early Readmissions in Decompensated Cirrhotic Patients: A Model Based on the Administrative Database. Hepatology. 2019;70(2):630-639. doi:10.1002/hep.30618
}
\examples{

# Example 1: High Risk
# 45yo (+4), Medicaid (+5), Ascites (+5), HE (+4), Paracentesis (+4)
# Score = 22
mumtaz_cirrhosis_readmission_score(45, "medicaid", 0, 0, 1, 1, 0, 0, 1, 0, "routine")

# Example 2: Low Risk
# 70yo (0), Private (0), Variceal Bleed (-7), No other factors
# Score = -7
mumtaz_cirrhosis_readmission_score(70, "private", 0, 0, 0, 0, 1, 0, 0, 0, "routine")
}
