\name{mipss70_score}
\alias{mipss70_score}
\title{
Mutation-Enhanced International Prognostic Score System (MIPSS70 and MIPSS70+) for Primary Myelofibrosis
}
\description{
Calculates the MIPSS70 and MIPSS70+ scores for risk stratification in patients with Primary Myelofibrosis (PMF) aged <= 70 years. The score integrates clinical risk factors, fibrosis grade, and mutational status (CALR, ASXL1, EZH2, SRSF2, IDH1/2). The MIPSS70+ version includes cytogenetic data.
}
\usage{
mipss70_score(hemoglobin_g_l, wbc_x10_9_l, platelets_x10_9_l, blasts_percent,
              fibrosis_grade_ge_2, constitutional_symptoms, calr_type1_absent,
              hmr_mutation_count, karyotype_unfavorable = NULL)
}
\arguments{
  \item{hemoglobin_g_l}{
Numeric. Hemoglobin level in g/L. (< 100 g/L adds 1 point).
}
  \item{wbc_x10_9_l}{
Numeric. White Blood Cell count in 10^9/L. (> 25 x 10^9/L adds 2 points).
}
  \item{platelets_x10_9_l}{
Numeric. Platelet count in 10^9/L. (< 100 x 10^9/L adds 2 points).
}
  \item{blasts_percent}{
Numeric. Percentage of circulating blasts. (>= 2\% adds 1 point).
}
  \item{fibrosis_grade_ge_2}{
Numeric (0 or 1). Is bone marrow fibrosis grade >= 2? (1 = Yes, +1 point).
}
  \item{constitutional_symptoms}{
Numeric (0 or 1). Presence of constitutional symptoms (fever, weight loss, night sweats). (1 = Yes, +1 point).
}
  \item{calr_type1_absent}{
Numeric (0 or 1). Absence of CALR type 1 mutation. (1 = Yes, +1 point).
}
  \item{hmr_mutation_count}{
Numeric. Count of High Molecular Risk (HMR) mutations present (ASXL1, EZH2, SRSF2, IDH1, IDH2).
0: 0 pts.
1: 1 pt.
>=2: 2 pts.
}
  \item{karyotype_unfavorable}{
Numeric (0 or 1) (Optional). Presence of unfavorable karyotype (e.g., complex karyotype, sole or two abnormalities including +8, -7/7q-, i(17q), inv(3), 5q-, 12p-, 11q23 rearrangement). If provided, calculates MIPSS70+ score. (1 = Yes, +3 points).
}
}
\value{
A list containing:
\item{MIPSS70_Score}{The calculated score based on clinical and molecular factors.}
\item{MIPSS70_Risk_Category}{Risk group (Low, Intermediate, High).}
\item{MIPSS70_Plus}{A list containing the MIPSS70+ Score and Risk Category if karyotype data was provided.}
}
\references{
Tefferi A, Guglielmelli P, Lasho TL, et al. MIPSS70: Mutation-Enhanced International Prognostic Score System for Transplantation-Age Patients With Primary Myelofibrosis. J Clin Oncol. 2018;36(4):310-318. doi:10.1200/JCO.2017.76.4886
}
\examples{

# Example 1: MIPSS70 High Risk
# Hb 90 (+1), WBC 30 (+2), HMR 2 (+2)
mipss70_score(90, 30, 150, 0, 0, 0, 0, 2)

# Example 2: MIPSS70+ Very High Risk
# Hb 110, Plt 80 (+2), Fibrosis 2 (+1), Unfavorable Karyotype (+3)
mipss70_score(110, 10, 80, 0, 1, 0, 0, 0, 1)
}
