\name{kocher_septic_arthritis}
\alias{kocher_septic_arthritis}
\title{
Kocher Criteria for Septic Arthritis
}
\description{
Calculates the Kocher Score to estimate the probability of septic arthritis in a pediatric patient presenting with a painful hip. The score is based on four clinical predictors: non-weight bearing, fever, elevated ESR, and elevated WBC count.
}
\usage{
kocher_septic_arthritis(non_weight_bearing, temp_gt_38_5, esr_gt_40, wbc_gt_12000)
}
\arguments{
  \item{non_weight_bearing}{
Numeric (0 or 1). Is the patient unable to bear weight on the affected side? (1 = Yes).
}
  \item{temp_gt_38_5}{
Numeric (0 or 1). Is the patient's temperature > 38.5 degrees Celsius? (1 = Yes).
}
  \item{esr_gt_40}{
Numeric (0 or 1). Is the Erythrocyte Sedimentation Rate (ESR) > 40 mm/hr? (1 = Yes).
}
  \item{wbc_gt_12000}{
Numeric (0 or 1). Is the White Blood Cell (WBC) count > 12,000 cells/mm^3? (1 = Yes).
}
}
\value{
A list containing:
\item{Kocher_Score}{The calculated score (Range 0-4).}
\item{Septic_Arthritis_Probability}{Estimated probability of septic arthritis based on the original validation data.}
}
\references{
Kocher MS, Zurakowski D, Kasser JR. Differentiating between septic arthritis and transient synovitis of the hip in children: an evidence-based clinical prediction algorithm. J Bone Joint Surg Am. 1999;81(12):1662-1670.
}
\examples{

# Example 1: High Probability
# Non-weight bearing (1), Fever (1), ESR 50 (1), WBC 15k (1)
# Score = 4
kocher_septic_arthritis(1, 1, 1, 1)

# Example 2: Low Probability
# Non-weight bearing (1), No fever, ESR 10, WBC 8k
# Score = 1
kocher_septic_arthritis(1, 0, 0, 0)
}
