\name{improve_bleeding_risk_score}
\alias{improve_bleeding_risk_score}
\title{
IMPROVE Bleeding Risk Score
}
\description{
Calculates the IMPROVE Bleeding Risk Score to estimate the probability of major or clinically relevant non-major bleeding within 14 days of hospital admission in acutely ill medical patients. This score helps balance the risk of bleeding against the benefit of VTE prophylaxis.
}
\usage{
improve_bleeding_risk_score(age, sex, gfr, active_cancer, rheumatic_disease,
                            central_venous_catheter, icu_ccu_admission,
                            hepatic_failure_inr_gt_1_5, platelet_count_lt_50,
                            prior_bleeding_3mo, active_gastroduodenal_ulcer)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{gfr}{
Numeric. Glomerular Filtration Rate (mL/min/1.73m^2).
}
  \item{active_cancer}{
Numeric (0 or 1). Active malignancy (excluding non-melanoma skin cancer) diagnosed or treated within the last 6 months.
}
  \item{rheumatic_disease}{
Numeric (0 or 1). History of rheumatic disease (e.g., RA, SLE).
}
  \item{central_venous_catheter}{
Numeric (0 or 1). Presence of a central venous catheter.
}
  \item{icu_ccu_admission}{
Numeric (0 or 1). Admission to an Intensive Care Unit (ICU) or Coronary Care Unit (CCU).
}
  \item{hepatic_failure_inr_gt_1_5}{
Numeric (0 or 1). Liver failure defined as INR > 1.5.
}
  \item{platelet_count_lt_50}{
Numeric (0 or 1). Thrombocytopenia (Platelet count < 50 x 10^9/L).
}
  \item{prior_bleeding_3mo}{
Numeric (0 or 1). Bleeding event within the 3 months prior to admission.
}
  \item{active_gastroduodenal_ulcer}{
Numeric (0 or 1). Active gastroduodenal ulcer.
}
}
\details{
\strong{Scoring Weights:}
Active Gastroduodenal Ulcer: +4.5
Prior Bleeding (<3mo): +4.0
Platelets < 50k: +4.0
Age >= 85: +3.5
Hepatic Failure (INR>1.5): +2.5
GFR < 30: +2.5
ICU/CCU: +2.5
CVC: +2.0
Rheumatic Disease: +2.0
Active Cancer: +2.0
Age 40-84: +1.5
Male Sex: +1.0
GFR 30-59: +1.0
}
\value{
A list containing:
\item{IMPROVE_Bleeding_Score}{The calculated total score (Range 0-30.5+).}
\item{Risk_Category}{Classification (Low < 7, High >= 7).}
\item{Bleeding_Probability_14_Days}{Estimated probability of any bleeding event within 14 days.}
}
\references{
Decousus H, Tapson VF, Bergmann JF, et al. Factors at admission associated with bleeding risk in medical patients: findings from the IMPROVE investigators. Chest. 2011;139(1):69-79. doi:10.1378/chest.09-3081
}
\examples{

# Example 1: High Risk
# Ulcer (+4.5), Male (+1.0), Age 45 (+1.5), GFR 40 (+1.0)
# Score = 8.0
improve_bleeding_risk_score(45, "male", 40, 0, 0, 0, 0, 0, 0, 0, 1)

# Example 2: Low Risk
# Female, Age 30, No risk factors
# Score = 0
improve_bleeding_risk_score(30, "female", 90, 0, 0, 0, 0, 0, 0, 0, 0)
}
