\name{hypoglycemia_risk_score}
\alias{hypoglycemia_risk_score}
\title{
Hypoglycemia Risk Score (Karter)
}
\description{
Calculates the 12-month risk of severe hypoglycemia (requiring ED or hospital admission) in patients with Type 2 Diabetes. This tool, derived by Karter et al. (2017), stratifies patients into Low, Intermediate, or High risk based on prior history, medication use, renal function, age, and healthcare utilization.
}
\usage{
hypoglycemia_risk_score(prior_hypo_episodes, insulin_use, sulfonylurea_use,
                        severe_ckd, age_years, total_ed_visits_12mo)
}
\arguments{
  \item{prior_hypo_episodes}{
Numeric. Number of hypoglycemia-related ED visits or hospitalizations in the prior 12 months.
0: 0 points.
1-2: 3 points.
>=3: 5 points.
}
  \item{insulin_use}{
Numeric (0 or 1). Current use of insulin. (1 = Yes, +3 points).
}
  \item{sulfonylurea_use}{
Numeric (0 or 1). Current use of sulfonylureas. (1 = Yes, +3 points).
}
  \item{severe_ckd}{
Numeric (0 or 1). Presence of severe Chronic Kidney Disease (Stage 3b, 4, 5 or eGFR < 45 mL/min). (1 = Yes, +2 points).
}
  \item{age_years}{
Numeric. Patient age in years. (< 77 years adds +2 points; >= 77 years adds 0 points). Note: Younger age in this specific older-adult cohort was associated with higher risk, potentially due to tighter glycemic control efforts.
}
  \item{total_ed_visits_12mo}{
Numeric. Total number of Emergency Department visits for *any* reason in the prior 12 months.
0: 0 points.
1: +1 point.
>=2: +2 points.
}
}
\value{
A list containing:
\item{Hypoglycemia_Risk_Score}{The calculated score (Range 0-17).}
\item{Risk_Level}{Classification (Low <=1, Intermediate 2-6, High >=7).}
\item{Est_12_Month_Risk}{Estimated percentage risk of severe hypoglycemia.}
}
\references{
Karter AJ, Warton EM, Lipska KJ, et al. Development and Validation of a Tool to Identify Patients With Type 2 Diabetes at High Risk of Hypoglycemia-Related Emergency Department or Hospital Use. JAMA Intern Med. 2017;177(10):1461-1470. doi:10.1001/jamainternmed.2017.3844
}
\examples{

# Example 1: High Risk
# 1 prior hypo (+3), Insulin (+3), Age 70 (+2), No CKD, 0 ED visits
# Score = 3 + 3 + 2 = 8
hypoglycemia_risk_score(1, 1, 0, 0, 70, 0)

# Example 2: Low Risk
# 0 prior, No Insulin, Sulfonylurea (+3), Age 80 (0), No CKD, 0 ED visits
# Score = 3 (Intermediate - wait, check thresholds: Low 0-1, Int 2-6. So Intermediate).
hypoglycemia_risk_score(0, 0, 1, 0, 80, 0)
}
