\name{fetal_biophysical_profile}
\alias{fetal_biophysical_profile}
\title{
Fetal Biophysical Profile (BPP) Score
}
\description{
Calculates the Fetal Biophysical Profile score to assess fetal well-being and identify risk of fetal hypoxia or acidosis. The profile evaluates five parameters: Non-Stress Test (NST), Amniotic Fluid Volume, Fetal Breathing Movements, Fetal Tone, and Fetal Body Movements. Each parameter is scored as 2 (Normal) or 0 (Abnormal).
}
\usage{
fetal_biophysical_profile(nst_reactive, amniotic_fluid_volume,
                          fetal_breathing_movements, fetal_tone,
                          fetal_body_movements)
}
\arguments{
  \item{nst_reactive}{
Numeric (0 or 2). Non-Stress Test result.
2: Reactive (>=2 accelerations of >=15 bpm for >=15 sec in 20 mins).
0: Non-reactive (<2 accelerations in 40 mins).
}
  \item{amniotic_fluid_volume}{
Numeric (0 or 2). Amniotic Fluid Volume.
2: Single deepest vertical pocket > 2 cm.
0: Largest pocket <= 2 cm (Oligohydramnios).
}
  \item{fetal_breathing_movements}{
Numeric (0 or 2). Fetal Breathing.
2: >= 1 episode of rhythmic breathing lasting >= 30 sec within 30 mins.
0: < 30 sec of breathing in 30 mins.
}
  \item{fetal_tone}{
Numeric (0 or 2). Fetal Tone.
2: >= 1 episode of extension of a fetal extremity with return to flexion (or opening/closing of hand).
0: Slow extension with partial return or no movement.
}
  \item{fetal_body_movements}{
Numeric (0 or 2). Fetal Movements.
2: >= 3 discrete body/limb movements within 30 mins.
0: < 3 movements.
}
}
\value{
A list containing:
\item{BPP_Total_Score}{The sum of the 5 component scores (Range 0-10).}
\item{Risk_Assessment}{Interpretation of fetal well-being (Normal, Equivocal, or Asphyxia).}
\item{Management_Guidance}{Clinical recommendations based on the score and amniotic fluid status.}
}
\references{
Manning FA, Platt LD, Sipos L. Antepartum fetal evaluation: development of a fetal biophysical profile. Am J Obstet Gynecol. 1980;136(6):787-795. doi:10.1016/0002-9378(80)90457-3
}
\examples{

# Example 1: Normal
# All parameters normal
fetal_biophysical_profile(2, 2, 2, 2, 2)

# Example 2: Equivocal (Score 6)
# Non-reactive NST, No breathing, others normal
fetal_biophysical_profile(0, 2, 0, 2, 2)

# Example 3: Oligohydramnios (Score 8 but AFV=0)
# All normal except fluid
fetal_biophysical_profile(2, 0, 2, 2, 2)
}
