\name{estimate_urinary_protein_excretion}
\alias{estimate_urinary_protein_excretion}
\title{
Urinary Protein Excretion Estimation (UPCR)
}
\description{
Estimates the 24-hour urinary protein excretion using a random spot urine sample. The calculation uses the Urine Protein to Creatinine Ratio (UPCR), which correlates well with 24-hour protein measurement.
}
\usage{
estimate_urinary_protein_excretion(urine_protein, urine_creatinine,
                                   urine_protein_units = "mg/dL",
                                   urine_creatinine_units = "mg/dL")
}
\arguments{
  \item{urine_protein}{
Numeric. Urine protein concentration.
}
  \item{urine_creatinine}{
Numeric. Urine creatinine concentration.
}
  \item{urine_protein_units}{
String. Units for urine protein. Options: "mg/dL" (default) or "g/L".
}
  \item{urine_creatinine_units}{
String. Units for urine creatinine. Options: "mg/dL" (default), "mmol/L", or "micromol/L".
}
}
\details{
The formula is based on the ratio:
\deqn{UPCR = \frac{Urine Protein (mg/dL)}{Urine Creatinine (mg/dL)}}
The resulting ratio represents the estimated grams of protein excreted per day (g/day).
}
\value{
A list containing:
\item{Estimated_Protein_Excretion_g_day}{The estimated 24-hour protein excretion in grams.}
\item{UPCR_Ratio}{The calculated protein/creatinine ratio.}
}
\references{
Ginsberg JM, Chang BS, Matarese RA, Garella S. Use of single voided urine samples to estimate quantitative proteinuria. N Engl J Med. 1983;309(25):1543-1546. doi:10.1056/NEJM198312223092503
}
\examples{

# Example 1: Nephrotic Range Proteinuria
# Protein 300 mg/dL, Creatinine 100 mg/dL
# Ratio = 3.0 g/day
estimate_urinary_protein_excretion(300, 100)

# Example 2: Using SI Units
# Protein 0.5 g/L -> 50 mg/dL
# Creatinine 10 mmol/L -> 113.1 mg/dL
# Ratio = 50 / 113.1 = 0.44 g/day
estimate_urinary_protein_excretion(0.5, 10, "g/L", "mmol/L")
}
