\name{dutch_lipid_clinic_score}
\alias{dutch_lipid_clinic_score}
\title{
Dutch Lipid Clinic Network Criteria for Familial Hypercholesterolemia (FH)
}
\description{
Calculates the Dutch Lipid Clinic Network (DLCN) score to assess the likelihood of Familial Hypercholesterolemia (FH) in an individual. The score aggregates points from family history, clinical history, physical examination, LDL cholesterol levels, and DNA analysis.
}
\usage{
dutch_lipid_clinic_score(ldl_cholesterol, family_history_score,
                         personal_premature_cad,
                         personal_premature_cerebral_peripheral,
                         exam_tendon_xanthoma, exam_arcus_cornealis_lt45,
                         genetic_mutation, ldl_units = "mg/dL")
}
\arguments{
  \item{ldl_cholesterol}{
Numeric. Pre-treatment LDL cholesterol level.
}
  \item{family_history_score}{
Numeric (0, 1, or 2). Points assigned for family history (choose the highest applicable):
0: None.
1: 1st-degree relative with premature coronary/vascular disease OR 1st-degree relative with LDL >95th percentile.
2: 1st-degree relative with tendon xanthomas/corneal arcus OR Child <18 with LDL >95th percentile.
}
  \item{personal_premature_cad}{
Numeric (0 or 1). Patient has premature coronary artery disease (Men <55, Women <60). (1 = Yes, +2 pts).
}
  \item{personal_premature_cerebral_peripheral}{
Numeric (0 or 1). Patient has premature cerebral or peripheral vascular disease (Men <55, Women <60). (1 = Yes, +1 pt).
}
  \item{exam_tendon_xanthoma}{
Numeric (0 or 1). Tendon xanthomas present on examination. (1 = Yes, +6 pts).
}
  \item{exam_arcus_cornealis_lt45}{
Numeric (0 or 1). Arcus cornealis present prior to age 45. (1 = Yes, +4 pts). Note: If both xanthoma and arcus are present, usually only the higher score (6) is applied for the exam category.
}
  \item{genetic_mutation}{
Numeric (0 or 1). Functional mutation in LDLR, APOB, or PCSK9 gene present. (1 = Yes, +8 pts).
}
  \item{ldl_units}{
String. Units for LDL input. "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{DLCN_Score}{The calculated total score.}
\item{Diagnosis}{Classification (Unlikely <3, Possible 3-5, Probable 6-8, Definite >8).}
}
\references{
World Health Organization. Familial hypercholesterolaemia (FH): Report of a second WHO consultation. Geneva. 1999.
}
\examples{

# Example 1: Definite FH
# LDL 350 mg/dL (+8), Tendon Xanthomas (+6)
# Score = 14
dutch_lipid_clinic_score(350, 0, 0, 0, 1, 0, 0)

# Example 2: Possible FH
# LDL 160 mg/dL (+1), Premature CAD (+2)
# Score = 3
dutch_lipid_clinic_score(160, 0, 1, 0, 0, 0, 0)
}
