\name{dsm5_ptsd_criteria}
\alias{dsm5_ptsd_criteria}
\title{
DSM-5 Criteria for Posttraumatic Stress Disorder (PTSD)
}
\description{
Evaluates the DSM-5 diagnostic criteria for PTSD. Diagnosis requires specific thresholds of symptoms in four clusters (Intrusion, Avoidance, Negative Alterations in Cognition/Mood, and Arousal/Reactivity) following exposure to a traumatic event, lasting more than 1 month, and causing functional impairment.
}
\usage{
dsm5_ptsd_criteria(exposure_criterion_a, intrusion_count_b, avoidance_count_c,
                   cognition_mood_count_d, arousal_reactivity_count_e,
                   duration_gt_1month, distress_impairment,
                   exclusion_criteria_ruled_out, dissociative_symptoms = 0)
}
\arguments{
  \item{exposure_criterion_a}{
Numeric (0 or 1). Exposure to actual or threatened death, serious injury, or sexual violence. (1 = Yes).
}
  \item{intrusion_count_b}{
Numeric. Number of intrusion symptoms present (e.g., memories, dreams, flashbacks). (Need >= 1).
}
  \item{avoidance_count_c}{
Numeric. Number of avoidance symptoms present. (Need >= 1).
}
  \item{cognition_mood_count_d}{
Numeric. Number of negative alterations in cognitions and mood present. (Need >= 2).
}
  \item{arousal_reactivity_count_e}{
Numeric. Number of alterations in arousal and reactivity present. (Need >= 2).
}
  \item{duration_gt_1month}{
Numeric (0 or 1). Duration of disturbance is more than 1 month. (1 = Yes).
}
  \item{distress_impairment}{
Numeric (0 or 1). Disturbance causes clinically significant distress or impairment. (1 = Yes).
}
  \item{exclusion_criteria_ruled_out}{
Numeric (0 or 1). Disturbance is not attributable to substance use or other medical condition. (1 = Yes).
}
  \item{dissociative_symptoms}{
Numeric (0 or 1). Presence of depersonalization or derealization. (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met" or "Criteria Not Met".}
\item{Subtype}{Specification if dissociative symptoms are present.}
\item{Missing_Criteria}{List of criteria groups that were not satisfied.}
}
\references{
American Psychiatric Association. Diagnostic and Statistical Manual of Mental Disorders. 5th ed. Arlington, VA: American Psychiatric Association; 2013.
}
\examples{

# Example 1: Diagnosis Met
# Stressor(1), 2 Intrusions, 1 Avoidance, 3 Mood, 2 Arousal, >1mo(1), Impaired(1), Exclusions(1)
dsm5_ptsd_criteria(1, 2, 1, 3, 2, 1, 1, 1)

# Example 2: Criteria Not Met (Insufficient Avoidance)
# Stressor(1), 2 Intrusions, 0 Avoidance, 2 Mood, 2 Arousal, >1mo(1), Impaired(1), Exclusions(1)
dsm5_ptsd_criteria(1, 2, 0, 2, 2, 1, 1, 1)
}
