\name{das28_crp_rheumatoid_arthritis}
\alias{das28_crp_rheumatoid_arthritis}
\title{
Disease Activity Score-28 for Rheumatoid Arthritis (DAS28-CRP)
}
\description{
Calculates the DAS28-CRP score, a standardized index of disease activity in Rheumatoid Arthritis. The score is calculated using the tender joint count (28 joints), swollen joint count (28 joints), C-Reactive Protein (CRP) level, and the patient's global assessment of health. It stratifies patients into Remission, Low, Moderate, or High disease activity.
}
\usage{
das28_crp_rheumatoid_arthritis(tender_joint_count, swollen_joint_count, crp,
                               patient_global_health, crp_units = "mg/L")
}
\arguments{
  \item{tender_joint_count}{
Numeric (0-28). Number of tender joints identified during examination.
}
  \item{swollen_joint_count}{
Numeric (0-28). Number of swollen joints identified during examination.
}
  \item{crp}{
Numeric. C-Reactive Protein level.
}
  \item{patient_global_health}{
Numeric (0-100). Patient's global assessment of health on a visual analog scale (0 = best/no activity, 100 = worst/highest activity).
}
  \item{crp_units}{
String. Units for the CRP input. Options: "mg/L" (default) or "mg/dL".
}
}
\value{
A list containing:
\item{DAS28_CRP_Score}{The calculated disease activity score.}
\item{Disease_Activity}{Classification (Remission < 2.6, Low 2.6-3.2, Moderate 3.2-5.1, High > 5.1).}
}
\references{
Prevoo ML, van 't Hof MA, Kuper HH, et al. Modified disease activity scores that include twenty-eight-joint counts. Development and validation in a prospective longitudinal study of patients with rheumatoid arthritis. Arthritis Rheum. 1995;38(1):44-48.
Wells G, Becker JC, Teng J, et al. Validation of the 28-joint Disease Activity Score (DAS28) and European League Against Rheumatism response criteria based on C-reactive protein against disease progression in patients with rheumatoid arthritis, and comparison with the DAS28 based on erythrocyte sedimentation rate. Ann Rheum Dis. 2009;68(6):954-960.
}
\examples{

# Example 1: High Disease Activity
# 10 tender, 8 swollen, CRP 25 mg/L, Global Health 60
das28_crp_rheumatoid_arthritis(10, 8, 25, 60)

# Example 2: Remission
# 0 tender, 0 swollen, CRP 1.0 mg/L, Global Health 10
das28_crp_rheumatoid_arthritis(0, 0, 1.0, 10)
}
