\name{crash_chemo_toxicity_score}
\alias{crash_chemo_toxicity_score}
\title{
CRASH Score (Chemotherapy Risk Assessment Scale for High-Age Patients)
}
\description{
Calculates the CRASH score to stratify the risk of severe chemotoxicity in patients aged 70 years or older. The tool generates two separate risk scores: one for Grade 4 Hematologic toxicity and one for Grade 3/4 Non-hematologic toxicity. It utilizes geriatric assessment variables (IADL, MMSE, MNA), clinical status (BP, ECOG, LDH), and the chemotherapeutic regimen risk (MAX2 index).
}
\usage{
crash_chemo_toxicity_score(diastolic_bp, iadl_score, ldh_elevated,
                           chemo_risk_max2, ecog_ps, mmse_score, mna_score)
}
\arguments{
  \item{diastolic_bp}{
Numeric. Diastolic blood pressure in mmHg. (<= 72 mmHg adds 2 points to Hematologic score).
}
  \item{iadl_score}{
Numeric. Instrumental Activities of Daily Living (IADL) score (OARS scale, 0-28). (< 28 adds 2 points to Hematologic score).
}
  \item{ldh_elevated}{
Numeric (0 or 1). Is Lactate Dehydrogenase (LDH) elevated above normal? (1 = Yes, +2 points to Hematologic score).
}
  \item{chemo_risk_max2}{
String. Chemotherapy regimen risk based on MAX2 index. Options: "low", "intermediate", "high".
(Adds points to both scores: Hema [0/1/1], Non-Hema [0/2/4]).
}
  \item{ecog_ps}{
Numeric (0-4). ECOG Performance Status. (1-2 adds 1 pt, 3-4 adds 2 pts to Non-Hema score).
}
  \item{mmse_score}{
Numeric. Mini-Mental State Examination score (0-30). (< 30 adds 1 point to Non-Hema score).
}
  \item{mna_score}{
Numeric. Mini Nutritional Assessment score (0-30). (< 28 adds 2 points to Non-Hema score).
}
}
\value{
A list containing:
\item{Scores}{Breakdown of Hematologic, Non-Hematologic, and Combined scores.}
\item{Hematologic_Toxicity_Risk}{Risk category and estimated rate of Grade 4 hematologic toxicity.}
\item{Non_Hematologic_Toxicity_Risk}{Risk category and estimated rate of Grade 3/4 non-hematologic toxicity.}
}
\references{
Extermann M, Boler I, Reich RR, et al. Predicting the risk of chemotherapy toxicity in older patients: the Chemotherapy Risk Assessment Scale for High-Age Patients (CRASH) score. Cancer. 2012;118(13):3377-3386. doi:10.1002/cncr.26646
}
\examples{

# Example 1: High Risk Patient
# DBP 70 (+2), IADL 25 (+2), LDH High (+2), Chemo High (+1 Hema, +4 Non-Hema)
# ECOG 1 (+1), MMSE 29 (+1), MNA 25 (+2)
# Hema Score: 2+2+2+1 = 7 (High Risk)
# Non-Hema Score: 1+1+2+4 = 8 (High Risk)
crash_chemo_toxicity_score(70, 25, 1, "high", 1, 29, 25)

# Example 2: Low Risk Patient
# DBP 80 (0), IADL 28 (0), LDH Normal (0), Chemo Low (0)
# ECOG 0 (0), MMSE 30 (0), MNA 30 (0)
# Hema Score: 0, Non-Hema Score: 0
crash_chemo_toxicity_score(80, 28, 0, "low", 0, 30, 30)
}
