\name{cha2ds2_va_score}
\alias{cha2ds2_va_score}
\title{
CHA2DS2-VA Score for Atrial Fibrillation Stroke Risk
}
\description{
Calculates the CHA2DS2-VA score to estimate stroke risk in patients with non-valvular atrial fibrillation. This score is a modification of the CHA2DS2-VASc score that excludes the sex category ("Sc"), addressing potential overestimation of risk in females and providing a uniform anticoagulation threshold.
}
\usage{
cha2ds2_va_score(age, chf_history, hypertension, diabetes,
                 stroke_tia_thromboembolism, vascular_disease)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 75: +2 points, 65-74: +1 point, < 65: 0 points).
}
  \item{chf_history}{
Numeric (0 or 1). Congestive Heart Failure history. (1 = Yes, +1 point).
}
  \item{hypertension}{
Numeric (0 or 1). History of Hypertension. (1 = Yes, +1 point).
}
  \item{diabetes}{
Numeric (0 or 1). History of Diabetes Mellitus. (1 = Yes, +1 point).
}
  \item{stroke_tia_thromboembolism}{
Numeric (0 or 1). History of Stroke, TIA, or Thromboembolism. (1 = Yes, +2 points).
}
  \item{vascular_disease}{
Numeric (0 or 1). History of Vascular Disease (e.g., prior MI, PAD, aortic plaque). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{CHA2DS2_VA_Score}{The calculated score (Range 0-8).}
\item{Risk_Category}{Risk classification (Low, Intermediate, High).}
\item{Annual_Stroke_Risk_No_Anticoagulation}{Estimated annual stroke risk percentage without anticoagulation.}
\item{Recommendation}{Clinical guidance regarding anticoagulation therapy.}
}
\references{
Nielsen PB, Skjøth F, Overvad TF, Larsen TB, Lip GY. Female Sex Is a Risk Modifier Rather Than a Risk Factor for Stroke in Atrial Fibrillation: Should We Use a CHA2DS2-VA Score? Circulation. 2018;137(8):832-840. doi:10.1161/CIRCULATIONAHA.117.029081
}
\examples{

# Example 1: Moderate Risk (Score 2)
# 68yo (+1), Hypertension (+1), No other factors
cha2ds2_va_score(68, 0, 1, 0, 0, 0)

# Example 2: High Risk (Score 5)
# 76yo (+2), Diabetes (+1), Prior Stroke (+2)
cha2ds2_va_score(76, 0, 0, 1, 1, 0)
}
