\name{ccs_angina_grade}
\alias{ccs_angina_grade}
\title{
Canadian Cardiovascular Society (CCS) Angina Grade
}
\description{
Determines the Canadian Cardiovascular Society (CCS) grading of angina pectoris. This standard classification system grades the severity of exertional angina based on the threshold of physical activity at which symptoms occur, ranging from Grade I (least severe) to Grade IV (most severe).
}
\usage{
ccs_angina_grade(inability_or_rest, marked_limitation, slight_limitation,
                 strenuous_only)
}
\arguments{
  \item{inability_or_rest}{
Numeric (0 or 1). Grade IV Criterion: Inability to carry on any physical activity without discomfort, OR angina syndrome is present at rest. (1 = Yes).
}
  \item{marked_limitation}{
Numeric (0 or 1). Grade III Criterion: Marked limitation of ordinary physical activity. Angina occurs on walking 1-2 blocks on the level and climbing 1 flight of stairs in normal conditions and at a normal pace. (1 = Yes).
}
  \item{slight_limitation}{
Numeric (0 or 1). Grade II Criterion: Slight limitation of ordinary activity. Angina occurs on walking >2 blocks on the level and climbing >1 flight of stairs in normal conditions and at a normal pace. (1 = Yes).
}
  \item{strenuous_only}{
Numeric (0 or 1). Grade I Criterion: Ordinary physical activity (walking, climbing stairs) does not cause angina. Angina occurs with strenuous, rapid, or prolonged exertion. (1 = Yes).
}
}
\value{
A list containing:
\item{CCS_Grade}{The calculated CCS Grade (I, II, III, or IV).}
\item{Description}{The clinical definition associated with the assigned grade.}
}
\references{
Campeau L. Grading of angina pectoris. Circulation. 1976;54(3):522-523. doi:10.1161/01.cir.54.3.522
}
\examples{

# Example 1: Severe Angina
# Patient has angina at rest
ccs_angina_grade(1, 0, 0, 0)

# Example 2: Moderate Angina
# Patient can walk 1-2 blocks but has marked limitation
ccs_angina_grade(0, 1, 0, 0)
}
