\name{bova_pe_score}
\alias{bova_pe_score}
\title{
Bova Score for Pulmonary Embolism Complications
}
\description{
Calculates the Bova Score to stratify the risk of PE-related complications (death, hemodynamic collapse, or recurrent PE) within 30 days in normotensive patients with acute pulmonary embolism. This tool helps identify patients who, despite being hemodynamically stable at presentation, are at intermediate-to-high risk for deterioration.
}
\usage{
bova_pe_score(sbp, heart_rate, troponin_elevated, rv_dysfunction)
}
\arguments{
  \item{sbp}{
Numeric. Systolic Blood Pressure in mmHg. (90-100 mmHg adds +2 points).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>= 110 bpm adds +1 point).
}
  \item{troponin_elevated}{
Numeric (0 or 1). Cardiac troponin elevated above the institutional upper limit of normal. (1 = Yes, +2 points).
}
  \item{rv_dysfunction}{
Numeric (0 or 1). Right Ventricular dysfunction visible on echocardiogram or CT. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{Bova_Score}{The calculated score (Range 0-7).}
\item{Risk_Stage}{Risk classification (Stage I: 0-2, Stage II: 3-4, Stage III: >4).}
\item{PE_Related_Complication_Risk_30Day}{Estimated percentage risk of complications within 30 days.}
}
\references{
Bova C, Sanchez O, Prandoni P, et al. Identification of intermediate-risk patients with acute symptomatic pulmonary embolism. Eur Heart J. 2014;35(20):1348-1356. doi:10.1093/eurheartj/ehu007
}
\examples{

# Example 1: High Risk (Stage III)
# SBP 95 (+2), HR 115 (+1), Troponin Neg (0), RV Dysfx (+2)
# Score = 5
bova_pe_score(95, 115, 0, 1)

# Example 2: Low Risk (Stage I)
# SBP 120 (0), HR 90 (0), Troponin Pos (+2), RV Normal (0)
# Score = 2
bova_pe_score(120, 90, 1, 0)
}
