\name{berlin_ards_criteria}
\alias{berlin_ards_criteria}
\title{
Berlin Criteria for Acute Respiratory Distress Syndrome (ARDS)
}
\description{
Applies the Berlin Definition to diagnostic criteria for ARDS. It evaluates timing, chest imaging, origin of edema, and oxygenation status to classify patients into Mild, Moderate, or Severe ARDS.
}
\usage{
berlin_ards_criteria(timing_within_1_week, bilateral_opacities,
                     edema_not_cardiac, pao2_fio2_ratio, peep_or_cpap)
}
\arguments{
  \item{timing_within_1_week}{
Numeric (0 or 1). Onset within 1 week of a known clinical insult or new/worsening respiratory symptoms. (1 = Yes).
}
  \item{bilateral_opacities}{
Numeric (0 or 1). Bilateral opacities on CXR or CT not fully explained by effusions, lobar/lung collapse, or nodules. (1 = Yes).
}
  \item{edema_not_cardiac}{
Numeric (0 or 1). Respiratory failure not fully explained by cardiac failure or fluid overload. (1 = Yes).
}
  \item{pao2_fio2_ratio}{
Numeric. Ratio of arterial partial pressure of oxygen to fraction of inspired oxygen (PaO2/FiO2) in mmHg.
Mild: 200 < Ratio <= 300.
Moderate: 100 < Ratio <= 200.
Severe: Ratio <= 100.
}
  \item{peep_or_cpap}{
Numeric. Positive End-Expiratory Pressure (PEEP) or Continuous Positive Airway Pressure (CPAP) in cmH2O. Must be >= 5 for diagnosis.
}
}
\value{
A list containing:
\item{Classification}{The severity class (Mild, Moderate, Severe, or Not ARDS).}
\item{Predicted_Mortality}{Estimated mortality risk based on the Berlin derivation cohort.}
\item{Failure_Reasons}{List of specific criteria that were not met.}
}
\references{
The ARDS Definition Task Force. Acute Respiratory Distress Syndrome: The Berlin Definition. JAMA. 2012;307(23):2526-2533. doi:10.1001/jama.2012.5669
}
\examples{

# Example 1: Severe ARDS
# Acute onset, Bilateral infiltrates, Non-cardiac, PF Ratio 80, PEEP 10
berlin_ards_criteria(1, 1, 1, 80, 10)

# Example 2: Not ARDS (PF Ratio too high)
# PF Ratio 350
berlin_ards_criteria(1, 1, 1, 350, 5)

# Example 3: Not ARDS (PEEP too low)
# PEEP 2
berlin_ards_criteria(1, 1, 1, 150, 2)
}
