\name{asdas_crp}
\alias{asdas_crp}
\title{
Ankylosing Spondylitis Disease Activity Score with CRP (ASDAS-CRP)
}
\description{
Calculates the ASDAS-CRP score, a composite index to assess disease activity in patients with Ankylosing Spondylitis (AS). It combines patient-reported outcomes (Back Pain, Morning Stiffness, Global Assessment, Peripheral Pain) with an objective inflammatory marker (CRP).
}
\usage{
asdas_crp(back_pain, duration_morning_stiffness, patient_global,
          peripheral_pain_swelling, crp_mg_l)
}
\arguments{
  \item{back_pain}{
Numeric (0-10). Severity of back pain (BASDAI Question 2).
}
  \item{duration_morning_stiffness}{
Numeric (0-10). Duration of morning stiffness (BASDAI Question 6).
}
  \item{patient_global}{
Numeric (0-10). Patient global assessment of disease activity.
}
  \item{peripheral_pain_swelling}{
Numeric (0-10). Severity of peripheral pain/swelling (BASDAI Question 3).
}
  \item{crp_mg_l}{
Numeric. C-Reactive Protein level in mg/L. (Note: If CRP < 2 mg/L, it is set to 2 for calculation).
}
}
\value{
A list containing:
\item{ASDAS_CRP_Score}{The calculated score.}
\item{Disease_Activity_State}{Classification (Inactive < 1.3, Moderate < 2.1, High <= 3.5, Very High > 3.5).}
}
\references{
Lukas C, Landewe R, Sieper J, et al. Development of an ASAS-endorsed disease activity score for ankylosing spondylitis (ASDAS). Ann Rheum Dis. 2009;68(1):18-24. doi:10.1136/ard.2008.094870
}
\examples{

# Example 1: High Disease Activity
# Back Pain 6, Stiffness 5, Global 6, Peripheral 4, CRP 10
asdas_crp(6, 5, 6, 4, 10)

# Example 2: Inactive Disease
# All scores 1, CRP 1.0
asdas_crp(1, 1, 1, 1, 1)
}
