\name{apache_ii_score}
\alias{apache_ii_score}
\title{
APACHE II Score
}
\description{
Calculates the Acute Physiology and Chronic Health Evaluation II (APACHE II) Score. This severity-of-disease classification system is used to estimate in-hospital mortality for adult patients admitted to the Intensive Care Unit (ICU). The score is calculated based on 12 physiological measurements, age, and chronic health status measured within the first 24 hours of ICU admission.
}
\usage{
apache_ii_score(age, temperature_c, mean_arterial_pressure, heart_rate,
                respiratory_rate, fio2, pao2, paco2 = NULL, arterial_ph,
                sodium, potassium, creatinine, acute_renal_failure,
                hematocrit, wbc_count, gcs_total, chronic_organ_insufficiency,
                admission_type)
}
\arguments{
  \item{age}{Numeric. Patient age in years.}
  \item{temperature_c}{Numeric. Rectal temperature in degrees Celsius.}
  \item{mean_arterial_pressure}{Numeric. Mean Arterial Pressure (MAP) in mmHg.}
  \item{heart_rate}{Numeric. Heart rate in bpm.}
  \item{respiratory_rate}{Numeric. Respiratory rate in breaths/min.}
  \item{fio2}{Numeric. Fraction of Inspired Oxygen (0.21 - 1.0).}
  \item{pao2}{Numeric. Arterial partial pressure of oxygen (mmHg).}
  \item{paco2}{Numeric (Optional). Arterial partial pressure of carbon dioxide (mmHg). Required only if FiO2 >= 0.5 for A-a gradient calculation.}
  \item{arterial_ph}{Numeric. Arterial pH.}
  \item{sodium}{Numeric. Serum sodium in mEq/L.}
  \item{potassium}{Numeric. Serum potassium in mEq/L.}
  \item{creatinine}{Numeric. Serum creatinine in mg/dL.}
  \item{acute_renal_failure}{Numeric (0 or 1). Presence of Acute Renal Failure (Doubles the creatinine points). (1 = Yes, 0 = No).}
  \item{hematocrit}{Numeric. Hematocrit percentage (e.g., 40 for 40\%).}
  \item{wbc_count}{Numeric. White Blood Cell count in x1000/mm3 (e.g., 10 for 10,000).}
  \item{gcs_total}{Numeric. Total Glasgow Coma Scale (3-15).}
  \item{chronic_organ_insufficiency}{Numeric (0 or 1). History of severe organ insufficiency (liver, CV, resp, renal) or immunocompromised state. (1 = Yes, 0 = No).}
  \item{admission_type}{String. Type of ICU admission. Options: "non_operative", "emergency_postop", "elective_postop".}
}
\value{
A list containing:
\item{APACHE_II_Score}{The calculated severity score (Range 0-71).}
\item{Est_Hospital_Mortality}{Approximate mortality percentage based on Knaus et al. (1985).}
}
\references{
Knaus WA, Draper EA, Wagner DP, Zimmerman JE. APACHE II: a severity of disease classification system. Crit Care Med. 1985;13(10):818-829.
}
\examples{

# Example 1: Critical Patient (High Score)
# 75yo, Temp 39, MAP 50, HR 140, RR 35, PaO2 50 (FiO2 0.4), pH 7.2, Na 130, K 6.0,
# Cr 2.0 (ARF), Hct 25, WBC 25, GCS 10, Chronic organ failure (Non-op)
apache_ii_score(75, 39, 50, 140, 35, 0.4, 50, NULL, 7.2,
130, 6.0, 2.0, 1, 25, 25, 10, 1, "non_operative")

# Example 2: Stable Post-Op
# 50yo, Normal vitals/labs, GCS 15, No chronic health issues, Elective surgery
apache_ii_score(50, 37, 90, 80, 16, 0.21, 90, NULL,
7.4, 140, 4.0, 1.0, 0, 40, 8, 15, 0, "elective_postop")
}
