\name{acr_eular_ra_2010}
\alias{acr_eular_ra_2010}
\title{
ACR/EULAR 2010 Rheumatoid Arthritis Classification Criteria
}
\description{
Calculates the score for the 2010 American College of Rheumatology (ACR) / European League Against Rheumatism (EULAR) Classification Criteria for Rheumatoid Arthritis (RA). A score of 6 or greater (out of 10) classifies a patient as having definite RA.

This criteria set is intended for use in patients who have at least 1 joint with definite clinical synovitis (swelling) and with the synovitis not better explained by another disease.
}
\usage{
acr_eular_ra_2010(joint_involvement, serology, acute_phase_reactants, duration_symptoms)
}
\arguments{
  \item{joint_involvement}{
Numeric. Score for joint involvement.
0: 1 large joint (0 points).
1: 2-10 large joints (1 point).
2: 1-3 small joints (with or without large joints) (2 points).
3: 4-10 small joints (with or without large joints) (3 points).
4: >10 joints (at least 1 small joint) (5 points).
}
  \item{serology}{
Numeric. Score for Rheumatoid Factor (RF) and Anti-Citrullinated Protein Antibody (ACPA).
0: Negative RF AND negative ACPA (0 points).
1: Low-positive RF OR low-positive ACPA (2 points).
2: High-positive RF OR high-positive ACPA (3 points).
(Negative: <= ULN; Low-positive: > ULN but <= 3x ULN; High-positive: > 3x ULN).
}
  \item{acute_phase_reactants}{
Numeric. Score for Acute-Phase Reactants (CRP and ESR).
0: Normal CRP AND normal ESR (0 points).
1: Abnormal CRP OR abnormal ESR (1 point).
}
  \item{duration_symptoms}{
Numeric. Duration of synovitis symptoms.
0: < 6 weeks (0 points).
1: >= 6 weeks (1 point).
}
}
\value{
A list containing:
\item{Total_Score}{The calculated classification score (Range 0-10).}
\item{Classification}{"Definite Rheumatoid Arthritis" if score >= 6, otherwise "Not Classified as Rheumatoid Arthritis".}
}
\references{
Aletaha D, Neogi T, Silman AJ, et al. 2010 Rheumatoid arthritis classification criteria: an American College of Rheumatology/European League Against Rheumatism collaborative initiative. Arthritis Rheum. 2010;62(9):2569-2581. doi:10.1002/art.27584
}
\examples{

# Example 1: Definite RA
# 4-10 small joints (3 pts), High-positive RF (3 pts), Normal CRP (0 pts), <6 weeks (0 pts)
# Total = 6
acr_eular_ra_2010(3, 2, 0, 0)

# Example 2: Not Classified
# 1-3 small joints (2 pts), Negative Serology (0 pts), Abnormal CRP (1 pt), >=6 weeks (1 pt)
# Total = 4
acr_eular_ra_2010(2, 0, 1, 1)
}
