% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_alternatives.R
\name{choice_alternatives}
\alias{choice_alternatives}
\alias{print.choice_alternatives}
\title{Define choice alternatives}
\usage{
choice_alternatives(
  J = 2,
  alternatives = LETTERS[1:J],
  base = NULL,
  ordered = FALSE
)

\method{print}{choice_alternatives}(x, ...)
}
\arguments{
\item{J}{[\code{integer(1)}]\cr
The number \eqn{\geq 2} of choice alternatives.}

\item{alternatives}{[\code{character(J)}]\cr
Unique labels for the choice alternatives.}

\item{base}{[\code{character(1)}]\cr
The name of the base alternative for alternative-constant covariates, see
details.

If \code{NULL} (default), it is set to the first element of the sorted
\code{alternatives}.}

\item{ordered}{[\code{logical(1)}]\cr
Should the supplied order of \code{alternatives} be preserved and treated as an
intrinsic ranking (for ordered response models)?

When \code{TRUE}, the alternatives are kept in the given order.

Otherwise, they are sorted alphabetically.}

\item{x}{[\code{choice_alternatives}]\cr
A \code{choice_alternatives} object.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{choice_alternatives}, i.e. a \code{character} vector of the
choice alternatives with attributes:
\describe{
\item{\code{J}}{The number of choice alternatives.}
\item{\code{base}}{The name of the base alternative.}
\item{\code{ordered}}{Do the alternatives encode an inherent ordering?}
}
}
\description{
The \code{choice_alternatives} object defines the set of choice alternatives.
}
\section{Base alternative}{

The full set of coefficients for covariates that are constant across
alternatives (including alternative-specific constants) is not identified.
To achieve identifiability, the coefficient of alternative \code{base}
is fixed to zero. The other coefficients then have to be interpreted with
respect to \code{base}. The base alternative is marked with a \code{*} when
printing a \code{choice_alternatives} object.
}

\examples{
choice_alternatives(
  J = 3,
  alternatives = c("gas", "electricity", "oil"),
  base = "gas"
)
}
\keyword{model}
