% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.matrix.checkglobalsi}
\alias{as.matrix.checkglobalsi}
\title{Cast to matrix}
\usage{
\method{as.matrix}{checkglobalsi}(x, pattern, ...)
}
\arguments{
\item{x}{object inheriting from class \code{"checkglobalsi"}.}

\item{pattern}{an optional \link{regular expression}.  Only names
matching \code{pattern} are returned. \code{\link{glob2rx}} can be
used to convert wildcard patterns to regular expressions.}

\item{...}{additional arguments to configure the output:
\itemize{
\item \code{all.names}, a logical value.  If \code{TRUE}, all object names are returned.
If \code{FALSE}, names which begin with a \samp{.} are omitted. Defaults to \code{TRUE}.
\item \code{sorted}, a logical value indicating if the function/variable names should be sorted alphabetically.
Defaults to \code{TRUE}.
}}
}
\value{
a matrix similar in format to \code{\link{as.matrix.checkglobals}}.
}
\description{
Cast an S3-object of class \code{"checkglobalsi"} to a matrix.
}
\examples{
## R-package from folder
chk <- checkglobals(
  pkg = system.file(
    "unit_tests", "pkg", "testpkg",
    package = "checkglobals"
  )
)
as.matrix(chk$imports)
}
\seealso{
\code{\link{as.matrix.checkglobals}}
}
