% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{pyr_single}
\alias{pyr_single}
\title{Build a Single Population Pyramid}
\usage{
pyr_single(data, use_prop = FALSE, color = "Fresh and bright")
}
\arguments{
\item{data}{A data frame containing population data for a specific province
and year. Must include variables \code{sex}, \code{age5}, and \code{pop}.}

\item{use_prop}{Logical, default \code{FALSE}. If \code{TRUE}, the pyramid will be shown
in proportions instead of absolute counts.}

\item{color}{Character string indicating the color palette name to use for
the pyramid. Available palettes come from
\link[ggthemes:canva_palettes]{ggthemes::canva_palettes}, e.g., \code{"Fresh and bright"}.}
}
\value{
A \code{ggplot} object representing the population pyramid.
}
\description{
Create a population pyramid for a given dataset (specific province and year),
either in absolute counts or in proportions, with customizable color palettes.
}
\examples{
\dontrun{
# Example data for Indonesia, 2020
data_idn <- pop_data_by_year(load_pop_data(), 2020) |>
  pop_data_by_reg(0) #Indonesia

# Absolute count pyramid
pyr_single(data_idn)

# Proportional pyramid with different palette
pyr_single(data_idn, use_prop = TRUE, color = "Professional and modern")
}
}
\seealso{
\code{\link[=ageprof]{ageprof()}}, \code{\link[=pyr_trends]{pyr_trends()}}, \code{\link[=load_pop_data]{load_pop_data()}}, \code{\link[=pop_data_by_reg]{pop_data_by_reg()}}, \code{\link[=pop_data_by_year]{pop_data_by_year()}}, \code{\link[=get_code_label]{get_code_label()}}
}
