% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{pop_data_by_year}
\alias{pop_data_by_year}
\title{Filter Population Data by Year}
\usage{
pop_data_by_year(data, yr)
}
\arguments{
\item{data}{A data frame or tibble containing population data.
Must include a column named \code{year}.}

\item{yr}{Integer or numeric. The census year to filter by.}
}
\value{
A tibble (or data frame) containing only rows from the specified year.
}
\description{
Filter population data for a specific census year. This function is intended
for use with population datasets loaded via \code{\link[=load_pop_data]{load_pop_data()}}, but can work
with any data frame that contains a \code{year} column.
}
\examples{
# Load harmonized data first
dat <- load_pop_data(harmonized = TRUE, smoothing = 1)

# Filter for the 2000 census year
pop_data_by_year(dat, 2000)
}
\seealso{
\code{\link[=load_pop_data]{load_pop_data()}}, \code{\link[=pop_data_by_reg]{pop_data_by_reg()}}
}
