#' cayleyR: Cayley Graph Analysis for Permutation Puzzles
#'
#' @description
#' Implements algorithms for analyzing Cayley graphs of permutation groups, with
#' a focus on the TopSpin puzzle and similar combinatorial problems. Provides
#' methods for cycle detection, state space exploration, and finding optimal
#' operation sequences in permutation groups generated by shift and reverse operations.
#'
#' @details
#' ## Main Features
#'
#' - **Basic permutation operations**: cyclic left/right shifts, prefix reversal
#' - **Cycle analysis**: find cycles in Cayley graphs with detailed state information
#' - **Sequence optimization**: search for operation sequences with maximum cycle length
#' - **Fast processing**: lightweight version for batch testing of combinations
#'
#' ## Main Functions
#'
#' **Basic Operations:**
#' - \code{\link{shift_left}} - Cyclic left shift
#' - \code{\link{shift_right}} - Cyclic right shift
#' - \code{\link{reverse_prefix}} - Reverse first k elements (turnstile operation)
#'
#' **Analysis Tools:**
#' - \code{\link{apply_operations}} - Apply sequence of operations
#' - \code{\link{get_reachable_states}} - Full cycle analysis with state tracking
#' - \code{\link{get_reachable_states_light}} - Lightweight cycle detection
#'
#' **Optimization:**
#' - \code{\link{find_best_random_combinations}} - Find best random sequences
#'
#'
#'
#' After installation from GitHub, visit:
#' \url{https://github.com/Zabis13/cayleyR}
#'
#' @section Getting Started:
#'
#' ```
#' library(cayleyR)
#'
#' # Basic operations
#' shift_left(1:5)
#' reverse_prefix(1:10, k = 4)
#'
#' # Cycle analysis for TopSpin 20-4
#' result <- get_reachable_states(
#'   start_state = 1:20,
#'   allowed_positions = c("L", "X"),
#'   k = 4
#' )
#' ```
#'
#'
#' @author Yuri Baramykov <lbsbmsu@mail.ru>
#'
#' @references
#' - TopSpin puzzle: \url{https://www.jaapsch.net/puzzles/topspin.htm}
#' - Cayley graphs: \url{https://en.wikipedia.org/wiki/Cayley_graph}
#'
#' @keywords internal
"_PACKAGE"
