% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probmat2amat.R
\name{probmat2amat}
\alias{probmat2amat}
\title{Convert a matrix of probabilities into an adjacency matrix}
\usage{
probmat2amat(
  probmat,
  threshold,
  method = "cutoff",
  keep_vnames = TRUE,
  graph_criterion = "pdag",
  deletesym = FALSE
)
}
\arguments{
\item{probmat}{Square matrix of probabilities.}

\item{threshold}{Value between 0 and 1. Any probabilities lower than
this value will be set to 0 (no arrowhead).}

\item{method}{Either \code{"cutoff"} or \code{"bpco"}, see details.}

\item{keep_vnames}{If \code{TRUE}, variable names (provided as rownames in the input probmat)
will be preserved in the output.}

\item{graph_criterion}{Which criterion to check if the output graph fulfills for the bpco
method. Should be one of \code{"dag"}, \code{"pdag"} or \code{"cpdag"}  or
\code{NULL}. Choosing \code{NULL} (the default) puts no further restrictions on the output.
See \code{\link[pcalg]{isValidGraph}} for definitions.}

\item{deletesym}{If \code{TRUE}, edges are deleted symmetrically in the bcpo method. This means that instead
of removing arrowheads (setting singular elements to 0), the procedure removes full edges (setting both potential
arrowheads for the given edge to zero). This only makes a difference if the graph may include undirected edges,
which should be encoded as bidirected edges.}
}
\value{
A square matrix of probabilities (all entries in [0,1]).
}
\description{
Convert a matrix of probabilities into an adjacency matrix
}
\details{
Two methods for converting the probability matrix into an adjacency
matrix are implemented. First, the cutoff-method (\code{method = "cutoff"}) simply
uses a threshold value and sets all values below that to zero in the outputted
adjacency matrix. No checks are performed to ensure that the resulting
matrix is a proper dag/pdag/cpdag adjacency matrix. Second, the backwards
PC orientation method (\code{method = "bpco"}) first uses a cutoff, and then
sets further elements to zero until the resulting matrix can be converted into
a proper adjacency matrix (using the graph criterion specified in the
\code{graph_criterion} argument) by applying the PC algorithm orientation rules.
See Petersen et al. 2022 for further details.
}
\examples{
#Make random probability matrix that can be 
#converted into adjancency matrix
pmat <- matrix(runif(25, 0, 1), 5, 5)
diag(pmat) <- 0

#Convert to adjacency matrix using cutoff-method (threshold = 0.5)
probmat2amat(pmat, threshold = 0.5)

#Convert to adjacency matrix using BPCO-method (threshold = 0.5)
probmat2amat(pmat, threshold = 0.5, method = "bpco")

}
\references{
Petersen, Anne Helby, et al. "Causal discovery for observational sciences using supervised machine learning."
arXiv preprint arXiv:2202.12813 (2022).
}
