% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate_sdm.r
\name{correlate_sdm}
\alias{correlate_sdm}
\title{Correlation between projections}
\usage{
correlate_sdm(i, scenario = "current")
}
\arguments{
\item{i}{A \code{input_sdm} object containing predictions.}

\item{scenario}{A \code{character} containing scenario to be tested. Standard is
\code{"current"}. Value must match \code{scenarios_names(i)}.}
}
\value{
A \code{data.frame} with pearson correlation between projections.
}
\description{
This function aims to unveil the correlation of different algorithms outputs.
For that, it uses the predictions on current scenario, but other scenarios can be tested.
}
\examples{
# Create sdm_area object:
set.seed(1)
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="random", n_set=2)

# Custom trainControl:
ctrl_sdm <- caret::trainControl(method = "boot",
                                number = 1,
                                repeats = 1,
                                classProbs = TRUE,
                                returnResamp = "all",
                                summaryFunction = summary_sdm,
                                savePredictions = "all")

# Train models:
i <- train_sdm(i, algo = c("naive_bayes"), ctrl=ctrl_sdm) |>
  suppressWarnings()

# Predict models:
i  <- predict_sdm(i, th = 0.8)

# Check correlations:
correlate_sdm(i)

}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
