% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixOmics.R
\name{axe-pls}
\alias{axe-pls}
\alias{axe-mixo_pls}
\alias{axe_call.mixo_pls}
\alias{axe_call.mixo_spls}
\alias{axe_data.mixo_pls}
\alias{axe_data.mixo_spls}
\alias{axe_fitted.mixo_pls}
\alias{axe_fitted.mixo_spls}
\title{Axing mixOmics models}
\usage{
\method{axe_call}{mixo_pls}(x, verbose = FALSE, ...)

\method{axe_call}{mixo_spls}(x, verbose = FALSE, ...)

\method{axe_data}{mixo_pls}(x, verbose = FALSE, ...)

\method{axe_data}{mixo_spls}(x, verbose = FALSE, ...)

\method{axe_fitted}{mixo_pls}(x, verbose = FALSE, ...)

\method{axe_fitted}{mixo_spls}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed \code{mixo_pls}, \code{mixo_spls}, or \code{mixo_plsda} object.
}
\description{
\code{mixo_pls} (via \code{pls()}), \code{mixo_spls} (via \code{spls()}), and \code{mixo_plsda}
(via \code{plsda()}) objects are created with the mixOmics package,
leveraged to fit partial least squares models.
}
\details{
The mixOmics package is not available on CRAN, but can be installed
from the Bioconductor repository via \code{remotes::install_bioc("mixOmics")}.
}
\examples{
\dontshow{if (rlang::is_installed("mixOmics") && !butcher:::is_cran_check()) withAutoprint(\{ # examplesIf}
library(butcher)
do.call(library, list(package = "mixOmics"))

# pls ------------------------------------------------------------------
fit_mod <- function() {
  boop <- runif(1e6)
  pls(matrix(rnorm(2e4), ncol = 2), rnorm(1e4), mode = "classic")
}

mod_fit <- fit_mod()
mod_res <- butcher(mod_fit)

weigh(mod_fit)
weigh(mod_res)

new_data <- matrix(1:2, ncol = 2)
colnames(new_data) <- c("X1", "X2")
predict(mod_fit, new_data)
predict(mod_res, new_data)
\dontshow{\}) # examplesIf}
}
