% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convo_add_reaction.R
\name{bs_add_reaction}
\alias{bs_add_reaction}
\title{Add a reaction (e.g. emoji) to a message in a conversation}
\usage{
bs_add_reaction(
  convo_id,
  message_id,
  value,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{convo_id}{Character, length 1. ID of the conversation to get.}

\item{message_id}{Character, length 1. Message ID.}

\item{value}{Character, length 1. Reaction value (e.g. an emoji).}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} or a \code{list} if \code{clean = FALSE}
}
\description{
Add a reaction (e.g. emoji) to a message in a conversation
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/chat/bsky/convo/addReaction.json}{chat.bsky.convo.addReaction.json (2025-05-16)}
}

\section{Function introduced}{

\code{v0.4.0} (2025-05-16)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_add_reaction(convo_id = '3ku7w6h4vog2d', message_id = '3lphbnrx7l32l', value = '\U0001F44D')
\dontshow{\}) # examplesIf}
}
\concept{chat}
