% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_visuals_hist.R
\name{bp_hist}
\alias{bp_hist}
\title{Blood Pressure Histograms}
\usage{
bp_hist(data, subj = NULL, bins = 30, na.rm = TRUE)
}
\arguments{
\item{data}{A processed dataframe resulting from the \code{process_data} function that
contains the \code{SBP}, \code{DBP}, \code{SBP_CATEGORY}, and \code{DBP_CATEGORY} columns.}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}

\item{bins}{An integer specifying how many bins to use for histogram plots. This is a ggplot parameter; default value set to 30}

\item{na.rm}{An logical value specifying whether or not to remove empty values from data frame.
This is a ggplot parameter; default value set to TRUE.}
}
\value{
A list containing four objects: three histogram visual graphics corresponding to
the SBP / DBP totals, SBP frequency, and DBP frequency, and a fourth list element
corresponding to a plot legend object for use in the \code{bp_report} function
}
\description{
The \code{bp_hist} function serves to display the frequencies of the \code{SBP}
and \code{DBP} readings. These histograms are formatted to complement the \code{bp_scatter}
function.
}
\examples{
data("bp_jhs")
data("bp_hypnos")
hyp_proc <- process_data(bp_hypnos,
                         bp_type = 'ABPM',
                         sbp = "syst",
                         dbp = "DIAST",
                         date_time = "date.time",
                         id = "id",
                         wake = "wake",
                         visit = "visit",
                         hr = "hr",
                         map = "map",
                         rpp = "rpp",
                         pp = "pp",
                         ToD_int = c(5, 13, 18, 23))

jhs_proc <- process_data(bp_jhs,
                         sbp = "Sys.mmHg.",
                         dbp = "Dias.mmHg.",
                         date_time = "DateTime",
                         hr = "pulse.bpm.")
rm(bp_hypnos, bp_jhs)

bp_hist(hyp_proc)
bp_hist(jhs_proc)
}
