% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock-stack.R
\name{new_dock_stack}
\alias{new_dock_stack}
\alias{is_dock_stack}
\alias{stack_color}
\alias{suggest_new_colors}
\alias{stack_color<-}
\alias{as_dock_stack}
\title{Colored stacks}
\usage{
new_dock_stack(..., color = suggest_new_colors())

is_dock_stack(x)

stack_color(x)

suggest_new_colors(colors = character(), n = 1)

stack_color(x) <- value

as_dock_stack(x, ...)
}
\arguments{
\item{...}{Passed to \code{\link[blockr.core:new_stack]{blockr.core::new_stack()}}}

\item{color}{String-valued color value (using hex encoding)}

\item{x}{object}

\item{colors}{Currently used color values}

\item{n}{Number of new colors to generate}

\item{value}{Replacement value}
}
\value{
The constructor \code{new_dock_stack()} returns a "dock_stack" object,
which is a stack object as returned by \code{\link[blockr.core:new_stack]{blockr.core::new_stack()}}, with an
additional color attribute. Inheritance can be checked using
\code{is_dock_stack()}, which returns a scalar logical and the color attribute
can be set and retrieved using \verb{stack_color<-()} (returns the modified stack
object invisibly) and \code{stack_color()} (returns a string), respectively.
Stack objects may be coerced to "dock_stack" using \code{as_dock_stack()} and
finally, a utility function \code{suggest_new_colors()} which returns a character
vector of new colors, based on an existing palette.
}
\description{
While stacks created via \code{\link[blockr.core:new_stack]{blockr.core::new_stack()}} do not keep track of
a color attribute, a \code{dock_stack} object does. Such objects can be created
via \code{new_dock_stack()}. The color attribute can be extracted using
\code{stack_color()} and set with \verb{stack_color<-()}. A new color suggestion,
based on existing colors, is available through \code{suggest_new_colors()}.
}
