% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-block.R, R/plot-scatter.R
\name{new_plot_block}
\alias{new_plot_block}
\alias{new_scatter_block}
\title{Plot block constructors}
\usage{
new_plot_block(server, ui, class, ctor = sys.parent(), ...)

new_scatter_block(x = character(), y = character(), ...)
}
\arguments{
\item{server}{A function returning \code{\link[shiny:moduleServer]{shiny::moduleServer()}}}

\item{ui}{A function with a single argument (\code{ns}) returning a \code{shiny.tag}}

\item{class}{Block subclass}

\item{ctor}{String-valued constructor name or function/frame number (mostly
for internal use or when defining constructors for virtual classes)}

\item{...}{Forwarded to \code{new_plot_block()} and \code{\link[=new_block]{new_block()}}}

\item{x, y}{Columns to place on respective axes}
}
\value{
All blocks constructed via \code{new_plot_block()} inherit from
\code{plot_block}.
}
\description{
Blocks for data visualization using base R graphics can be created via
\code{new_plot_block()}.
}
\details{
Due to the current block evaluation procedure, where block evaluation is
separated from block "rendering" (via  \code{\link[shiny:renderPlot]{shiny::renderPlot()}}) integration of
base R graphics requires some mechanism to achieve this decoupling. This
is implemented by adding a \code{plot} attribute to the result of
\code{\link[=block_eval]{block_eval()}}, generated with \code{\link[grDevices:recordplot]{grDevices::recordPlot()}} and containing the
required information to re-create the plot at a later time. As part of
\code{\link[=block_output]{block_output()}}, the attribute is retrieved and passed to
\code{\link[grDevices:recordplot]{grDevices::replayPlot()}}. Consequently, any block that inherits from
\code{plot_block} is required to support this type of decoupling.
}
\section{Scatter block}{

Mainly for demonstration purposes, this block draws a scattter plot using
\code{\link[base:plot]{base::plot()}}. In its current simplistic implementation, apart from axis
labels (fixed to the corresponding column names), no further plotting
options are available and for any "production" application, a more
sophisticated (set of) block(s) for data visualization will most likely be
required.
}

