% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{pls_threshold}
\alias{pls_threshold}
\title{Naive sparsity control by coefficient thresholding}
\usage{
pls_threshold(object, threshold)
}
\arguments{
\item{object}{A fitted PLS model.}

\item{threshold}{Values below this absolute magnitude are set to zero.}
}
\value{
A modified copy of \code{object} with thresholded coefficients.
}
\description{
Naive sparsity control by coefficient thresholding
}
\examples{
set.seed(123)
X <- matrix(rnorm(40), nrow = 10)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(10, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2)
pls_threshold(fit, threshold = 0.05)
}
