# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

cpp_dense_cross <- function(X_, Y_, use_syrk_opt = NULL, use_dgemm_opt = NULL) {
    .Call(`_bigPLSR_cpp_dense_cross`, X_, Y_, use_syrk_opt, use_dgemm_opt)
}

cpp_dense_scores <- function(X_, mu_x_, W_) {
    .Call(`_bigPLSR_cpp_dense_scores`, X_, mu_x_, W_)
}

#' Fast IRLS for binomial logit with class weights
#'
#' @param TT n x A numeric matrix of latent scores (no intercept column)
#' @param ybin integer vector of \{0,1\} labels (length n)
#' @param w_class optional length-2 numeric vector: weights for classes c( w0, w1 )
#' @param maxit max IRLS iterations
#' @param tol relative tolerance on parameter change
#'
#' @return list(beta = A-vector, b = scalar intercept, fitted = n-vector,
#'              iter = integer, converged = logical)
#'
cpp_irls_binomial <- function(TT, ybin, w_class = NULL, maxit = 50L, tol = 1e-8) {
    .Call(`_bigPLSR_cpp_irls_binomial`, TT, ybin, w_class, maxit, tol)
}

#' Internal kernel and wide-kernel PLS solver
#'
#' @param X Centered design matrix.
#' @param Y Centered response matrix.
#' @param ncomp Maximum number of components.
#' @param tol Numerical tolerance.
#' @param wide Whether to use the wide-kernel update.
#' @return A list containing the kernel PLS factors.
#'
cpp_kernel_pls <- function(X, Y, ncomp, tol, wide) {
    .Call(`_bigPLSR_cpp_kernel_pls`, X, Y, ncomp, tol, wide)
}

cpp_kf_pls_dense <- function(X_, Y_, ncomp, tol, lambda, q_proc) {
    .Call(`_bigPLSR_cpp_kf_pls_dense`, X_, Y_, ncomp, tol, lambda, q_proc)
}

cpp_kf_pls_bigmem <- function(X_ptr, Y_ptr, ncomp, chunk_rows, tol, lambda, q_proc) {
    .Call(`_bigPLSR_cpp_kf_pls_bigmem`, X_ptr, Y_ptr, ncomp, chunk_rows, tol, lambda, q_proc)
}

cpp_kf_pls_state_new <- function(p, m, ncomp, lambda = 0.99, q_proc = 0.0, r_meas = 0.0) {
    .Call(`_bigPLSR_cpp_kf_pls_state_new`, p, m, ncomp, lambda, q_proc, r_meas)
}

cpp_kf_pls_state_update <- function(state_xptr, X_, Y_) {
    invisible(.Call(`_bigPLSR_cpp_kf_pls_state_update`, state_xptr, X_, Y_))
}

cpp_kf_pls_state_fit <- function(state_xptr, tol = 1e-8) {
    .Call(`_bigPLSR_cpp_kf_pls_state_fit`, state_xptr, tol)
}

cpp_kpls_rkhs_xy_dense <- function(X_, Y_, ncomp, tol, kernel_x, gamma_x, degree_x, coef0_x, kernel_y, gamma_y, degree_y, coef0_y, lambda_x, lambda_y) {
    .Call(`_bigPLSR_cpp_kpls_rkhs_xy_dense`, X_, Y_, ncomp, tol, kernel_x, gamma_x, degree_x, coef0_x, kernel_y, gamma_y, degree_y, coef0_y, lambda_x, lambda_y)
}

cpp_klogit_pls_fit <- function(X, y, ncomp, tol = 1e-6, maxit = 25L) {
    .Call(`_bigPLSR_cpp_klogit_pls_fit`, X, y, ncomp, tol, maxit)
}

cpp_klogit_pls_dense <- function(X, y, ncomp, tol, kernel, gamma, degree, coef0, class_weights) {
    .Call(`_bigPLSR_cpp_klogit_pls_dense`, X, y, ncomp, tol, kernel, gamma, degree, coef0, class_weights)
}

cpp_klogit_pls_bigmem <- function(X_ptr, y, ncomp, chunk, tol, kernel, gamma, degree, coef0, class_weights) {
    .Call(`_bigPLSR_cpp_klogit_pls_bigmem`, X_ptr, y, ncomp, chunk, tol, kernel, gamma, degree, coef0, class_weights)
}

cpp_kernel_gram_block <- function(X, r0, r1, c0, c1, kernel, gamma, degree, coef0) {
    .Call(`_bigPLSR_cpp_kernel_gram_block`, X, r0, r1, c0, c1, kernel, gamma, degree, coef0)
}

cpp_kpls_from_gram <- function(K_, Y_, ncomp, tol) {
    .Call(`_bigPLSR_cpp_kpls_from_gram`, K_, Y_, ncomp, tol)
}

cpp_kpls_rkhs_dense <- function(X, Y, ncomp, tol, kernel, gamma, degree, coef0, approx, approx_rank) {
    .Call(`_bigPLSR_cpp_kpls_rkhs_dense`, X, Y, ncomp, tol, kernel, gamma, degree, coef0, approx, approx_rank)
}

cpp_kpls_rkhs_bigmem <- function(X_ptr, Y, ncomp, tol, kernel, gamma, degree, coef0, approx, approx_rank, chunk_rows = 8192L, chunk_cols = 8192L) {
    .Call(`_bigPLSR_cpp_kpls_rkhs_bigmem`, X_ptr, Y, ncomp, tol, kernel, gamma, degree, coef0, approx, approx_rank, chunk_rows, chunk_cols)
}

cpp_sparse_kpls_dense <- function(X, Y, ncomp, tol) {
    .Call(`_bigPLSR_cpp_sparse_kpls_dense`, X, Y, ncomp, tol)
}

cpp_kpls_stream_cols <- function(X_ptr, Y_ptr, ncomp, chunk_cols, center, return_big) {
    .Call(`_bigPLSR_cpp_kpls_stream_cols`, X_ptr, Y_ptr, ncomp, chunk_cols, center, return_big)
}

cpp_kpls_stream_xxt <- function(X_ptr, Y_ptr, ncomp, chunk_rows, chunk_cols, center, return_big) {
    .Call(`_bigPLSR_cpp_kpls_stream_xxt`, X_ptr, Y_ptr, ncomp, chunk_rows, chunk_cols, center, return_big)
}

cpp_bigmem_cross <- function(X_ptrSEXP, Y_ptrSEXP, chunk_size) {
    .Call(`_bigPLSR_cpp_bigmem_cross`, X_ptrSEXP, Y_ptrSEXP, chunk_size)
}

cpp_simpls_from_cross <- function(XtX, XtY, x_mean, y_mean, ncomp, tol) {
    .Call(`_bigPLSR_cpp_simpls_from_cross`, XtX, XtY, x_mean, y_mean, ncomp, tol)
}

cpp_stream_scores_given_W <- function(X_ptrSEXP, W, x_mean, chunk_size, scores_sinkSEXP, return_big) {
    .Call(`_bigPLSR_cpp_stream_scores_given_W`, X_ptrSEXP, W, x_mean, chunk_size, scores_sinkSEXP, return_big)
}

pls_nipals_bigmemory <- function(X_ptrSEXP, y_ptrSEXP, ncomp, center, scale, tol, max_iter, return_big) {
    .Call(`_bigPLSR_pls_nipals_bigmemory`, X_ptrSEXP, y_ptrSEXP, ncomp, center, scale, tol, max_iter, return_big)
}

pls_streaming_bigmemory <- function(X_ptrSEXP, y_ptrSEXP, ncomp, chunk_size, center, scale, tol, return_big) {
    .Call(`_bigPLSR_pls_streaming_bigmemory`, X_ptrSEXP, y_ptrSEXP, ncomp, chunk_size, center, scale, tol, return_big)
}

cpp_big_pls_stream_fit_sink <- function(X_ptrSEXP, y_ptrSEXP, scores_sinkSEXP, ncomp, chunk_size, tol, return_big) {
    .Call(`_bigPLSR_cpp_big_pls_stream_fit_sink`, X_ptrSEXP, y_ptrSEXP, scores_sinkSEXP, ncomp, chunk_size, tol, return_big)
}

cpp_dense_plsr_nipals <- function(X, Y, ncomp, tol, compute_scores = FALSE, scores_big = FALSE, scores_name = "scores") {
    .Call(`_bigPLSR_cpp_dense_plsr_nipals`, X, Y, ncomp, tol, compute_scores, scores_big, scores_name)
}

big_plsr_fit_nipals <- function(X_ptr, Y_ptr, ncomp, center = TRUE, scale = FALSE, return_big = FALSE) {
    .Call(`_bigPLSR_big_plsr_fit_nipals`, X_ptr, Y_ptr, ncomp, center, scale, return_big)
}

big_plsr_stream_fit_nipals <- function(X_ptr, Y_ptr, ncomp, center = TRUE, scale = FALSE, chunk_size = 1024L, return_big = FALSE) {
    .Call(`_bigPLSR_big_plsr_stream_fit_nipals`, X_ptr, Y_ptr, ncomp, center, scale, chunk_size, return_big)
}

