% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdf.R
\name{bdf_codelist}
\alias{bdf_codelist}
\title{Fetch Banque de France (BdF) codelists}
\source{
\url{https://webstat.banque-france.fr/en/pages/guide-migration-api/}
}
\usage{
bdf_codelist(...)
}
\arguments{
\item{...}{(\code{any})\cr
Extra arguments appended to the API request.
Combined with the default arguments with \code{\link[=modifyList]{modifyList()}}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Fetch Banque de France (BdF) codelists
}
\examples{
\dontrun{
bdf_codelist()

# filter for a specific codelist
bdf_codelist(where = "codelist_id = 'CL_FREQ'")
}
}
\seealso{
Other data: 
\code{\link{bbk_data}()},
\code{\link{bbk_series}()},
\code{\link{bde_data}()},
\code{\link{bdf_data}()},
\code{\link{bdf_dataset}()},
\code{\link{boc_data}()},
\code{\link{boe_data}()},
\code{\link{ecb_data}()},
\code{\link{onb_data}()},
\code{\link{snb_data}()}
}
\concept{data}
