% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-panels.R
\name{plot_BrS_panel}
\alias{plot_BrS_panel}
\title{Plot bronze-standard (BrS) panel}
\usage{
plot_BrS_panel(
  slice,
  data_nplcm,
  model_options,
  clean_options,
  bugs.dat,
  res_nplcm,
  bg_color,
  select_latent = NULL,
  exact = TRUE,
  top_BrS = 1.3,
  cexval = 1,
  srtval = 0,
  prior_shape = "interval",
  silent = TRUE
)
}
\arguments{
\item{slice}{the index of measurement slice for BrS.}

\item{data_nplcm}{See \code{\link[=nplcm]{nplcm()}}}

\item{model_options}{See \code{\link[=nplcm]{nplcm()}}}

\item{clean_options}{See \code{\link[=clean_perch_data]{clean_perch_data()}}}

\item{bugs.dat}{Data input for the model fitting.}

\item{res_nplcm}{See \code{\link[=nplcm_read_folder]{nplcm_read_folder()}}}

\item{bg_color}{A list with names "BrS", "SS", "pie" to specify background colors}

\item{select_latent}{a vector of character strings representing latent status. It is used for
just plotting a subset of latent status. For example, you can specify \code{select_latent = "HINF"}
to plot all latent status information relevant to \code{"HINF"}.}

\item{exact}{Default is \code{TRUE} to use \code{select_latent} as exact names of causes. If you want to
specify a name and plot all single or combo causes with that name, specify it to be \code{FALSE}.}

\item{top_BrS}{Numerical value to specify the rightmost limit
on the horizontal axis for the BrS panel.}

\item{cexval}{Default is 1 - size of text of the BrS percentages.}

\item{srtval}{Default is 0 - the direction of the text for the BrS percentages.}

\item{prior_shape}{\code{interval} or \code{boxplot} - for how to represent
prior/posteriors of the TPR/FPRs of measurements.}

\item{silent}{Default is TRUE to not print any warning messages; FALSE otherwise.}
}
\value{
plotting function.
}
\description{
Plot bronze-standard (BrS) panel
}
\seealso{
Other visualization functions: 
\code{\link{plot.nplcm}()},
\code{\link{plot_SS_panel}()},
\code{\link{plot_check_common_pattern}()},
\code{\link{plot_check_pairwise_SLORD}()},
\code{\link{plot_etiology_regression}()},
\code{\link{plot_etiology_strat}()},
\code{\link{plot_panels}()},
\code{\link{plot_pie_panel}()},
\code{\link{plot_subwt_regression}()}
}
\concept{visualization functions}
