% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encoding}
\alias{encoding}
\alias{av_encode_video}
\alias{av}
\alias{av_video_convert}
\alias{av_audio_convert}
\title{Encode or Convert Audio / Video}
\usage{
av_encode_video(
  input,
  output = "output.mp4",
  framerate = 24,
  vfilter = "null",
  codec = NULL,
  audio = NULL,
  verbose = TRUE
)

av_video_convert(video, output = "output.mp4", verbose = TRUE)

av_audio_convert(
  audio,
  output = "output.mp3",
  format = NULL,
  channels = NULL,
  sample_rate = NULL,
  bit_rate = NULL,
  start_time = NULL,
  total_time = NULL,
  verbose = interactive()
)
}
\arguments{
\item{input}{a vector with image or video files. A video input file is treated
as a series of images. All input files should have the same width and height.}

\item{output}{name of the output file. File extension must correspond to a known
container format such as \code{mp4}, \code{mkv}, \code{mov}, or \code{flv}.}

\item{framerate}{video framerate in frames per seconds. This is the input fps, the
output fps may be different if you specify a filter that modifies speed or interpolates
frames.}

\item{vfilter}{a string defining an ffmpeg filter graph. This is the same parameter
as the \code{-vf} argument in the \code{ffmpeg} command line utility.}

\item{codec}{name of the video codec as listed in \link{av_encoders}. The
default is \code{libx264} for most formats, which usually the best choice.}

\item{audio}{audio or video input file with sound for the output video}

\item{verbose}{emit some output and a progress meter counting processed images. Must
be \code{TRUE} or \code{FALSE} or an integer with a valid \link{av_log_level}.}

\item{video}{input video file with optionally also an audio track}

\item{format}{a valid output format name from the list of \code{av_muxers()}. Default
\code{NULL} infers format from the file extension.}

\item{channels}{number of output channels. Default \code{NULL} will match input.}

\item{sample_rate}{output sampling rate. Default \code{NULL} will match input.}

\item{bit_rate}{output bitrate (quality). A common value is 192000. Default
\code{NULL} will match input.}

\item{start_time}{number greater than 0, seeks in the input file to position.}

\item{total_time}{approximate number of seconds at which to limit the duration
of the output file.}
}
\description{
Encodes a set of images into a video, using custom container format, codec, fps,
\href{https://ffmpeg.org/ffmpeg-filters.html#Video-Filters}{video filters}, and audio
track. If input contains video files, this effectively combines and converts them
to the specified output format.
}
\details{
The target container format and audio/video codes are automatically determined from
the file extension of the output file, for example \code{mp4}, \code{mkv}, \code{mov}, or \code{flv}.
For video output, most systems also support \code{gif} output, but the compression~quality
for gif is really bad. The \href{https://cran.r-project.org/package=gifski}{gifski} package
is better suited for generating animated gif files. Still using a proper video format
is results in much better quality.

It is recommended to use let ffmpeg choose the suitable codec for a given container
format. Most video formats default to the \code{libx264} video codec which has excellent
compression and works on all modern browsers, operating systems, and digital TVs.

To convert from/to raw PCM audio, use file extensions \code{".ub"} or \code{".sb"} for 8bit
unsigned or signed respectively, or \code{".uw"} or \code{".sw"} for 16-bit, see \code{extensions}
in \code{\link[=av_muxers]{av_muxers()}}. Alternatively can also convert to other raw audio PCM by setting
for example \code{format = "u16le"} (i.e. unsigned 16-bit little-endian) or another option
from the \code{name} column in \code{\link[=av_muxers]{av_muxers()}}.

It is safe to interrupt the encoding process by pressing CTRL+C, or via \link{setTimeLimit}.
When the encoding is interrupted, the output stream is properly finalized and all open
files and resources are properly closed.
}
\seealso{
Other av: 
\code{\link{capturing}},
\code{\link{demo}()},
\code{\link{formats}},
\code{\link{info}},
\code{\link{logging}},
\code{\link{read_audio_fft}()}
}
\concept{av}
