% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_process_species_names.R
\name{process_species_names}
\alias{process_species_names}
\title{Process and fix species names}
\usage{
process_species_names(species, processing = "all", enforce = FALSE)
}
\arguments{
\item{species}{character. String with the name of the species to be processed.}

\item{processing}{character. One of \code{"trim"}, \code{"sp nov"}, \code{"hyphen broken"}, \code{"abbreviate"}, \code{"spacing"} and \code{"all"}. By default set to \code{"all"}, performing every edit.}

\item{enforce}{boolean. Remove non-conforming entries before returning.}
}
\value{
character. A string with the standardized species name.
}
\description{
This function standardizes species names and fixes a number of 
common typos and mistakes that commonly occur due to OCR.
}
\examples{
process_species_names("macro - thele calpeiana sp. nov.")
}
