% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createBindingConstraint.R
\name{createBindingConstraint}
\alias{createBindingConstraint}
\title{Create a binding constraint}
\usage{
createBindingConstraint(
  name,
  id = tolower(name),
  values = NULL,
  enabled = TRUE,
  timeStep = c("hourly", "daily", "weekly"),
  operator = c("both", "equal", "greater", "less"),
  filter_year_by_year = "hourly, daily, weekly, monthly, annual",
  filter_synthesis = "hourly, daily, weekly, monthly, annual",
  coefficients = NULL,
  group = NULL,
  overwrite = FALSE,
  opts = simOptions()
)
}
\arguments{
\item{name}{The name for the binding constraint.}

\item{id}{An id, default is to use the name.}

\item{values}{Values used by the constraint.
It contains one line per time step and three columns "less", "greater" and "equal"
(see documentation below if you're using version study >= v8.7.0)}

\item{enabled}{Logical, is the constraint enabled ?}

\item{timeStep}{Time step the constraint applies to : \code{hourly}, \code{daily} or \code{weekly}.}

\item{operator}{Type of constraint: equality, inequality on one side or both sides.}

\item{filter_year_by_year}{Marginal price granularity for year by year}

\item{filter_synthesis}{Marginal price granularity for synthesis}

\item{coefficients}{A named list containing the coefficients used by the constraint,
the coefficients have to be alphabetically ordered see examples below for entering
weight or weight with offset.}

\item{group}{"character" group of the constraint, default value : "default group"}

\item{overwrite}{If the constraint already exist, overwrite the previous value.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Create a new binding constraint in an Antares study.
}
\details{
According to Antares version, usage may vary :

\strong{< v8.7.0} : For each constraint name, a .txt file containing 3 time series \verb{"less", "greater", "equal"}

\strong{>= v8.7.0} : For each constraint name, one file .txt containing \verb{<id>_lt.txt, <id>_gt.txt, <id>_eq.txt}
Parameter \code{values} must be named \code{list} ("lt", "gt", "eq") containing \code{data.frame} scenarized.
see example section below.
}
\examples{
\dontrun{
# < v8.7.0 :

# Create constraints with multi coeffs (only weight)

createBindingConstraint(
  name = "myconstraint", 
  values = matrix(data = rep(0, 8760 * 3), ncol = 3), 
  enabled = FALSE, 
  timeStep = "hourly",
  operator = "both",
  coefficients = list("area1\%area2" = 1,
    "area1\%area3" = 2)
)

# Create constraints with multi coeffs + offset

createBindingConstraint(
  name = "myconstraint", 
  values = matrix(data = rep(0, 8760 * 3), ncol = 3), 
  enabled = FALSE, 
  timeStep = "hourly",
  operator = "both",
  coefficients = list("area1\%area2" = "1\%1",
    "area1\%area3" = "2\%3")
)


# >= v8.7.0 :

# values are now named list containing `data.frame` according to   
 # `operator` parameter (for "less", build a list with at least "lt" floor in list)
 
# data values (hourly)
df <- matrix(data = rep(0, 8760 * 3), ncol = 3)
values_data <- list(lt=df)
 
# create bc with minimum value
createBindingConstraint(name = "bc_example", 
                        operator = "less", 
                        values = values_data, 
                        overwrite = TRUE)
                        
# or you can provide list data with all value
values_data <- list(lt=df, 
                   gt= df, 
                   eq= df)   
                   
createBindingConstraint(name = "bc_example", 
                        operator = "less", 
                        values = values_data, 
                        overwrite = TRUE)      
                        
}
}
\seealso{
Other binding constraints functions: 
\code{\link{createBindingConstraintBulk}()},
\code{\link{editBindingConstraint}()},
\code{\link{removeBindingConstraint}()}
}
\concept{binding constraints functions}
