% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amap_http.R
\name{amap_config}
\alias{amap_config}
\title{Configure Amap settings}
\usage{
amap_config(
  signature = NULL,
  secret = NULL,
  key = NULL,
  enabled = TRUE,
  max_active = NULL,
  throttle = NULL
)
}
\arguments{
\item{signature}{Optional.
Signature configuration. Use `FALSE` to disable, a single string secret, or a list.}

\item{secret}{Optional.
Secret key used for request signing.}

\item{key}{Optional.
Optional API key override when signing is enabled.}

\item{enabled}{Optional.
Logical flag to enable or disable signing.}

\item{max_active}{Optional.
Maximum number of active concurrent HTTP requests when bulk operations are
executed with `httr2::req_perform_parallel()`. Defaults to 3.}

\item{throttle}{Optional.
Throttling configuration for outgoing HTTP requests.
Use `FALSE` to disable throttling, `TRUE` to enable with defaults, or a list
with any of the following fields:
`enabled` (logical), `rate` (numeric), `capacity` (numeric),
`fill_time_s` (numeric), and `realm` (character).

Defaults are safe for AutoNavi's QPS limits: `max_active = 3` and
`throttle = list(rate = 3, fill_time_s = 1)`.}
}
\description{
Configure Amap settings
}
