test_that("rocsesp_auc",{
  ## ========================================================
  library(alternativeROC)
  library(pROC)
  ## ========================================================
  for(seed in 1:20) {
    set.seed(seed+100)
    n <- 1e2 ; pow <- rnorm(1,mean=2,sd=1)
    x <- c(stats::rnorm(n),stats::rnorm(n)^pow)
    y <- rep(1:0,each=n)
    roc <- pROC::roc(y,x,quiet=TRUE)
    res <- alternativeROC:::rocsesp(roc$controls,roc$cases,roc$direction=="<")
    auc <- alternativeROC:::rocsesp_auc(res)
    testthat::expect_true(abs(auc-roc$auc)<1e-6)
  }
  ## ========================================================
})
