% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LQRFE_main.R
\name{qr}
\alias{qr}
\title{quantile regression}
\usage{
qr(x, y, subj, tau = 0.5, method = "qrfe", ngrid = 20, inf = 1e-08, digt = 4)
}
\arguments{
\item{x}{Numeric matrix, covariates}

\item{y}{Numeric vector, outcome.}

\item{subj}{Numeric vector, identifies the unit to which the observation belongs.}

\item{tau}{Numeric, identifies the percentile.}

\item{method}{Factor, "qr" quantile regression, "qrfe" quantile regression with fixed effects, "lqrfe" Lasso quantile regression with fixed effects, "alqrfe" adaptive Lasso quantile regression with fixed effects.}

\item{ngrid}{Numeric scalar greater than one, number of BIC to test.}

\item{inf}{Numeric scalar, internal value, small value.}

\item{digt}{Numeric scalar, internal value greater than one, define "zero" coefficient.}
}
\value{
alpha       Numeric vector, intercepts' coefficients.

beta        Numeric vector, exploratory variables' coefficients.

lambda      Numeric, estimated lambda.

res         Numeric vector, percentile residuals.

tau         Numeric scalar, the percentile.

penalty     Numeric scalar, indicate the chosen effect.

sig2_alpha  Numeric vector, intercepts' standard errors.

sig2_beta   Numeric vector, exploratory variables' standard errors.

Tab_alpha   Data.frame, intercepts' summary.

Tab_beta    Data.frame, exploratory variables' summary.

Mat_alpha   Numeric matrix, intercepts' summary.

Mat_beta    Numeric matrix, exploratory variables' summary.

method      Factor, method applied.
}
\description{
Estimate quantile regression parameters for any quantile.   

\bold{Remarks:}  

1. If the first column of `x` is entirely equal to 1, then the first element of `beta` represents the common intercept.  
   Otherwise, there is no default common intercept (unlike the default behavior in `lm`).  

2. If there is a common intercept and `method` is `"qrfe"`, `"lqrfe"` or `"alqrfe"`, a 'sum-to-zero constraint' is applied on the `alpha` parameters:  
   \deqn{\sum_{i=1}^{n} \alpha_i = 0}  
   This follows the approach in Danilevicz (2025).
}
\examples{
# Example 1
n = 10
m = 5
d = 4
N = n*m
L = N*d
x = matrix(rnorm(L), ncol=d, nrow=N)
subj = rep(1:n, each=m)
alpha = rnorm(n)
beta = rnorm(d)
eps = rnorm(N)
y = x \%*\% beta  + matrix(rep(alpha, each=m) + eps)
y = as.vector(y)
m1 = qr(x,y,subj,tau=0.75, method="qrfe")
m1
m2 = qr(x,y,subj,tau=0.3, method="lqrfe", ngrid = 10)
m2

# Example 2, from MASS package
Rabbit = MASS::Rabbit
Rabbit$Treatment = ifelse(Rabbit$Treatment=="Control",0,1)
Rabbit$Animal = ifelse(Rabbit$Animal == "R1",1,ifelse(Rabbit$Animal == "R2",2,
ifelse(Rabbit$Animal == "R3",3,ifelse(Rabbit$Animal == "R4",4,5))))
X = matrix(cbind(Rabbit$Dose,Rabbit$Treatment), ncol=2)
m3 = qr(x=X, y=Rabbit$BPchange, subj=Rabbit$Animal,tau=0.5, method="alqrfe", ngrid = 10)
m3

}
\references{
Danilevicz, I.M., Bondon, P., Reisen, V.A. (2025) "Adaptive LASSO Quantile Regression with Fixed Effects", Appl. Math. Model., xx (xx), <doi:10.1016/j.apm.2025.116600>

Danilevicz, I.M., Reisen, V.A., Bondon, P. (2024) "Expectile and M-quantile regression for panel data", Stat. Comput., 34 (97), <doi:10.1007/s11222-024-10396-7>

Koenker, R. (2004) "Quantile regression for longitudinal data", J. Multivar. Anal., 91(1): 74-89, <doi:10.1016/j.jmva.2004.05.006>
}
