% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icREML.R
\name{ic_reml_asr}
\alias{ic_reml_asr}
\title{Find the AIC and BIC for a set of models fitted using asreml}
\usage{
ic_reml_asr(fm, scale = 1)
}
\arguments{
\item{fm}{A \code{list} of asreml fitted model objects}

\item{scale}{A scalar to scale the variance matrix of the estimated
fixed effects (to ensure numerical stability of a log-determinant).
Default value is 1.}
}
\value{
A data frame.  The data frame has the following components
\itemize{
\item \code{model} : the names of the models
\item \code{loglik} : the full log-likelihood for each model
\item \code{p} :  the number of fixed effects parameters for each model
\item \code{q} : the number of (non-zero) variance parameters for each model.
\item \code{b} : the number of variance parameters that are fixed or on the
boundary.  These parameters are not counted in the AIC or BIC.
\item \code{AIC} : the AIC for each model
\item \code{BIC} : the BIC for each model
\item \code{logdet} : the log-determinant used in adjusting the residual
log-likelihood for each model
}
}
\description{
The function is a wrapper for 'icREML' function described
in Verbyla (2019).
}
\references{
Verbyla, A. P. (2019). A note on model selection using information
criteria for general linear models estimated using REML. Australian &
New Zealand Journal of Statistics, 61(1), 39-50.
}
\author{
Ari Verbyla (averbyla at avdataanalytics.com.au)
}
