% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directory.R
\name{adf_directory}
\alias{adf_directory}
\alias{adf_directory.adf_device}
\alias{adf_directory<-}
\alias{adf_directory<-.adf_device}
\alias{adf_directory<-.adf_device.character}
\alias{adf_directory<-.adf_device.virtual_path}
\alias{make_adf_dir}
\alias{make_adf_dir.adf_device}
\alias{make_adf_dir.virtual_path}
\alias{make_adf_dir.adf_device.character}
\alias{make_adf_dir.adf_device.virtual_path}
\title{Changing and creating directories on a virtual device}
\usage{
adf_directory(dev, ...)

\method{adf_directory}{adf_device}(dev, ...)

adf_directory(dev, ...) <- value

\method{adf_directory}{adf_device}(dev, ...) <- value

\method{adf_directory}{adf_device.character}(dev, ...) <- value

\method{adf_directory}{adf_device.virtual_path}(dev, ...) <- value

make_adf_dir(x, path, ...)

\method{make_adf_dir}{adf_device}(x, path, ...)

\method{make_adf_dir}{virtual_path}(x, path, ...)

\method{make_adf_dir.adf_device}{character}(x, path, ...)

\method{make_adf_dir.adf_device}{virtual_path}(x, path, ...)
}
\arguments{
\item{dev}{The virtual adf device for which information needs to be obtained.
It should be of class \code{adf_device} which can be created with \code{\link[=create_adf_device]{create_adf_device()}}
or \code{\link[=connect_adf]{connect_adf()}}.}

\item{...}{Ignored}

\item{value}{A \code{character} string or a \code{virtual_path} (see \code{\link[=virtual_path]{virtual_path()}})
representing directory you wish to set as current.}

\item{x}{An \code{adf_device} or \code{virtual_path} class object. The first specifies
the device on which a directory needs to be created. The latter specifies
both the directory and the device on which it needs to be created.}

\item{path}{A \code{character} string or a \code{virtual_path} (see \code{\link[=virtual_path]{virtual_path()}})
specifying the name of the new directory to be created. Should be missing when \code{x} is
of class \code{virtual_path}}
}
\value{
\code{make_adf_dir()} returns the device connection. \code{adf_directory()} returns
the current directory as a \code{virtual_path} class object.
}
\description{
\code{adf_directory()} shows the current directory of a virtual device, when a file
system is present. When connecting to or creating a new device, the current
directory is the disk's root by default. To change the current directory,
use \code{adf_directory()} in combination with the assign operator (\verb{<-}).
}
\details{
To create a new directory on a device use \code{make_adf_dir()} and use a full or
relative path name to specify the new directory name.

See \code{vignette("virtual_paths")} for a note on file and directory names on the Amiga.
}
\examples{
## Open virtual device to demonstrate methods
my_device <- demo_adf(write_protected = FALSE)

## Show the current directory
adf_directory(my_device)

## Create a new directory
make_adf_dir(my_device, "DF0:s/newdir")

## Change the current dir to the new directory:
adf_directory(my_device) <- "DF0:s/newdir"

## Close the virtual device
close(my_device)
}
\author{
Pepijn de Vries
}
