% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abn-methods.R
\name{as.data.frame.abnDag}
\alias{as.data.frame.abnDag}
\title{Transform the adjacency matrix representation of a DAG to a data.frame
with columns "from" and "to" representing directed edges.}
\usage{
\method{as.data.frame}{abnDag}(x, ...)
}
\arguments{
\item{x}{An object of class abnDag}

\item{...}{Additional arguments (currently unused)}
}
\value{
A data.frame with columns "from" and "to" representing directed edges
from parent nodes (from) to child nodes (to)
}
\description{
Transform the adjacency matrix representation of a DAG to a data.frame
with columns "from" and "to" representing directed edges.
}
\details{
The adjacency matrix in abnDag objects has parents in columns and
children in rows. A value of 1 at position (i,j) indicates an arc from
parent j to child i.
}
\examples{
# Create example DAG matrix
mydag <- createAbnDag(dag = ~a+b|a, data.df = data.frame("a"=1, "b"=1))

# Convert to edge list
as.data.frame(mydag)
}
