% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_helpers.R
\name{df_read_table}
\alias{df_read_table}
\title{Data frame loading from a file.}
\usage{
df_read_table(file, force_numeric = FALSE, ...)
}
\arguments{
\item{file}{The path to the file you want to load. See
\code{read.table()} documentation for more information.}

\item{force_numeric}{If set to TRUE, all integer columns will be
converted to numeric.}

\item{...}{Parameter to transmit to the read.table function.}
}
\value{
The loaded data frame.
}
\description{
df_read_table
Reads a data frame from a file and possibly convert integer columns to
numeric. This function calls the built-in \code{read.table()} method and
then \code{W4MRUtils::df_force_numeric()}.
}
\examples{
# Load a data frame from a file and convert integer columns
file_path <- system.file(
  "extdata",
  "example_df_read_table.csv",
  package="W4MRUtils"
)
str(W4MRUtils::df_read_table(
  file_path,
  sep = ",",
  force_numeric = TRUE,
  header=TRUE
))

}
