% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{CDsXML_Legacy}
\alias{CDsXML_Legacy}
\title{Import catchment descriptors from older .xml files}
\usage{
CDsXML_Legacy(x)
}
\arguments{
\item{x}{the xml file path}
}
\value{
A data.frame with columns; Descriptor and Value.
}
\description{
Imports catchment descriptors from xml files (prior to FEH2025) either from an FEH webservice download or from the Peakflows dataset downloaded from the national river flow archive (NRFA) website
}
\details{
This function is to allow users to import catchment descriptors in the format prior to the 2025 update.
}
\examples{

# Import catchment descriptors from a FEH webserver XML file and display XML in the console
\dontrun{
cds_my_site <- CDsXML(r"{C:\Data\FEH_Catchment_384200_458200.xml}")
cds_my_site
}

}
\author{
Anthony Hammond
}
