% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\title{Generate Stepwise Regression Report}
\usage{
report(x, report_name, format = c("html", "docx", "rtf", "pptx"))
}
\arguments{
\item{x}{A StepReg object containing the results of stepwise regression analysis.}

\item{report_name}{Character. The name of the output report file(s) without extension.}

\item{format}{Character vector. The output format(s) for the report. Choose from:
\itemize{
  \item "html" - Web page format (default)
  \item "docx" - Microsoft Word document
  \item "pptx" - Microsoft PowerPoint presentation
  \item "rtf" - Rich Text Format
}
Multiple formats can be specified simultaneously.}
}
\value{
Creates report file(s) in the specified format(s) in the current working directory.
The file name will be \code{report_name.format} (e.g., "myreport.html", "myreport.docx").
}
\description{
Creates formatted reports from StepReg objects in various document formats. This function
generates comprehensive reports containing all tables and results from the stepwise regression
analysis.
}
\details{
The generated report includes:
  \itemize{
    \item Summary of model parameters and selection criteria
    \item Variable types and classifications
    \item Step-by-step selection process
    \item Final selected model and fit statistics
    \item Model coefficients and significance levels
  }
}
\examples{
\dontrun{
# Load leukemia remission data
data(remission)

# Run stepwise logistic regression
formula <- remiss ~ .
result <- stepwise(
  formula = formula,
  data = remission,
  type = "logit",
  strategy = c("forward", "bidirection"),
  metric = c("AIC", "BIC")
)

# Generate reports in multiple formats
report(
  x = result,
  report_name = "leukemia_analysis",
  format = c("html", "docx")
)
}

}
\seealso{
\code{\link{stepwise}} for creating StepReg objects

\code{\link{plot.StepReg}} for visualization of results
}
