% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_2r.R
\name{p_2r}
\alias{p_2r}
\alias{gen_2r}
\title{p-value from comparing two or more correlations simulation}
\usage{
p_2r(
  n,
  r.ab,
  r.ab2 = NULL,
  r.ac,
  r.bc,
  r.ad,
  r.bd,
  r.cd,
  n2_n1 = 1,
  two.tailed = TRUE,
  test = NULL,
  gen_fun = gen_2r,
  return_analysis = FALSE,
  ...
)

gen_2r(n, R, ...)
}
\arguments{
\item{n}{sample size}

\item{r.ab}{correlation between variable A and B (for independent groups,
this is for sample 1)}

\item{r.ab2}{(for independent group test only) correlation between
variable A and B in sample 2}

\item{r.ac}{(for overlap/non-overlap) correlation between A and C. This is the correlation
used in the overlapping hypothesis test, comparing this input to \code{r.ab}}

\item{r.bc}{(for overlap/non-overlap only) correlation between B and C.}

\item{r.ad}{(for non-overlap only) correlation between A and D}

\item{r.bd}{(for non-overlap only) correlation between B and D}

\item{r.cd}{(for non-overlap only) correlation between C and D. This is the correlation
used in the non-overlapping hypothesis test, comparing this input to \code{r.ab}}

\item{n2_n1}{sample size ratio. Only used for independent group test}

\item{two.tailed}{logical; use two-tailed test?}

\item{test}{hypothesis testing method to use. Defaults to \code{'fisher1925'}
for the independent groups test and \code{'steiger1980'} for overlap/non-overlap tests}

\item{gen_fun}{function used to generate the required discrete data.
Object returned must be a \code{matrix} with \code{n} rows.
Default uses \code{\link{gen_2r}}.
User defined version of this function must include the argument \code{...}}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}

\item{R}{a correlation matrix constructed from the inputs
to \code{\link{p_2r}}}
}
\value{
a single p-value
}
\description{
Function utilizes \code{\link[cocor]{cocor}} to perform correlation
comparison for independent, overlapping, and non-overlapping correlation designs.
Type type of correlation design is inferred based on which correlations are
specified.
}
\details{
For independent group tests, only \code{r.ab} and \code{r.ab2} need to be specified,
where the null hypothesis pertains to \eqn{H_0: r_{ab}=r_{ab2}}.

For overlapping correlation tests, \code{r.ab}, \code{r.ac}, and \code{r.bc}
need to be specified, where the null hypothesis pertains to \eqn{H_0: r_{ab}=r_{ac}}.

For non-overlapping correlation tests, all correlations expect for \code{r.ab2} must be
specified, where the null hypothesis pertains to \eqn{H_0: r_{ab}=r_{cd}}.
}
\examples{

# independent (same x-y pairing across groups)
p_2r(100, r.ab=.5, r.ab2=.6)

# return cocor object for further analysis
p_2r(100, r.ab=.5, r.ab2=.6, return_analysis = TRUE)

\donttest{

   # estimate empirical power
   p_2r(n=100, r.ab=.5, r.ab2=.6) |> Spower()

   # estimate n required to reach 80\% power
   p_2r(n=NA, r.ab=.5, r.ab2=.6) |>
        Spower(power=.80, interval=c(100, 5000))

}

# overlap (same y, different xs)
# H0: r.ab = r.bc
p_2r(100, r.ab=.5, r.ac=.3, r.bc=.2)

# nonoverlap (different ys, different xs)
# H0: r.ab = r.cd
p_2r(100, r.ab=.5, r.ac=.3, r.bc=.2, r.ad=.2, r.bd=.4, r.cd=.2)


}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
