% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{sm_plot_topic_terms}
\alias{sm_plot_topic_terms}
\title{Plot Topic Term Probabilities}
\usage{
sm_plot_topic_terms(model, n_terms = 10, topics = NULL)
}
\arguments{
\item{model}{A fitted topic model (LDA, STM, or CTM).}

\item{n_terms}{Number of top terms to display per topic. Default is 10.}

\item{topics}{Vector of topic numbers to display. If NULL, shows all topics.
Default is NULL.}
}
\value{
A ggplot object.
}
\description{
Creates a bar chart showing the top terms for each topic, based on their
beta (topic-word) probabilities.
}
\examples{
\dontrun{
# Requires trained model from sm_train_lda()
lda_model <- sm_train_lda(dtm, k = 10)
sm_plot_topic_terms(lda_model, n_terms = 15)
}
}
